/*******************************************************************************
Copyright (C) 2015 Annapurna Labs Ltd.

This file may be licensed under the terms of the Annapurna Labs Commercial
License Agreement.

Alternatively, this file can be distributed under the terms of the GNU General
Public License V2 as published by the Free Software Foundation and can be
found at http://www.gnu.org/licenses/gpl-2.0.html

Alternatively, redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following conditions are
met:

    *     Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

    *     Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in
the documentation and/or other materials provided with the
distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/
#ifndef _AL_SERDES_25G_INTERNAL_REGS_H_
#define  _AL_SERDES_25G_INTERNAL_REGS_H_

#ifdef _cplusplus
extern "C" {
#endif

/*******************************************************************************
 * TOP Registers
 ******************************************************************************/
#define SERDES_25G_TOP_BASE						0x00
#define SERDES_25G_TOP_SIZE						0x200

#define SERDES_25G_TOP_PHY_STAT0_ADDR					0x00
#define SERDES_25G_TOP_PHY_CTRL0_ADDR					0x08
#define SERDES_25G_TOP_PHY_CFG0_ADDR					0x09
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL0_ADDR				0x30
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL1_ADDR				0x31
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_ADDR				0x32
#define SERDES_25G_TOP_AFE_CALCOMP_STATUS0_ADDR				0x33
#define SERDES_25G_TOP_AFE_ATEST_CTRL0_ADDR				0x38
#define SERDES_25G_TOP_AFE_ATEST_CTRL1_ADDR				0x39
#define SERDES_25G_TOP_RESET_CTRL_CM0_ADDR				0x50
#define SERDES_25G_TOP_RESET_CTRL_LN0_ADDR				0x54
#define SERDES_25G_TOP_RESET_CTRL_LN1_ADDR				0x55
#define SERDES_25G_TOP_RESET_CTRL_LN2_ADDR				0x56
#define SERDES_25G_TOP_RESET_CTRL_LN3_ADDR				0x57
#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_ADDR			0x100
#define SERDES_25G_TOP_CLOCK_CM0_CLK_REF_ADDR				0x101
#define SERDES_25G_TOP_CLOCK_CM0_REFCLK_ADDR				0x102
#define SERDES_25G_TOP_CLOCK_CM0_CLK_SSC_GEN_ADDR			0x103
#define SERDES_25G_TOP_CLOCK_CM0_CLK_GCFSM_ADDR				0x104
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMPLL_VCO_ADDR			0x105
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_ADDR				0x106
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_CTRL1_ADDR			0x107
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_ADDR			0x108
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_CTRL1_ADDR			0x109
#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_ADDR			0x10A
#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_ADDR				0x110
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_ADDR			0x111
#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_ADDR				0x112
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_ADDR		0x113
#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_ADDR				0x118
#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_ADDR			0x119
#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_ADDR				0x11A
#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RXDIV_CORE_ADDR		0x11B
#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_ADDR				0x120
#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_ADDR			0x121
#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_ADDR				0x122
#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RXDIV_CORE_ADDR		0x123
#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_ADDR				0x128
#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_ADDR			0x129
#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_ADDR				0x12A
#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RXDIV_CORE_ADDR		0x12B
#define SERDES_25G_TOP_LOS_INT_EN_CTRL_ADDR				0x130
#define SERDES_25G_TOP_INT0_STATUS_ADDR					0x131
#define SERDES_25G_TOP_REGBUS_TIMER_ADDR				0x170
#define SERDES_25G_TOP_ERR_CTRL0_ADDR					0x180
#define SERDES_25G_TOP_ERR_CTRL1_ADDR					0x181
#define SERDES_25G_TOP_ERR_CTRL2_ADDR					0x182
#define SERDES_25G_TOP_ERR_STATUS0_ADDR					0x185
#define SERDES_25G_TOP_REGBUS_ERR_INFO_CTRL_ADDR			0x187
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS0_ADDR			0x188
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS1_ADDR			0x189
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS2_ADDR			0x18A
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS3_ADDR			0x18B
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS4_ADDR			0x18C
#define SERDES_25G_TOP_TBUS_ADDR_7_0_ADDR				0x1A0
#define SERDES_25G_TOP_TBUS_ADDR_15_8_ADDR				0x1A1
#define SERDES_25G_TOP_TBUS_CTRL0_ADDR					0x1A2
#define SERDES_25G_TOP_TBUS_CTRL1_ADDR					0x1A3
#define SERDES_25G_TOP_TBUS_DATA_7_0_ADDR				0x1B0
#define SERDES_25G_TOP_TBUS_DATA_11_8_ADDR				0x1B1
#define SERDES_25G_TOP_SIM_CTRL_ADDR					0x1C0

/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_TOP_PHY_STAT0_PHY_CTRL_CFG_MASK			0x0F
#define SERDES_25G_TOP_PHY_STAT0_PHY_CTRL_CFG_SHIFT			0

#define SERDES_25G_TOP_PHY_CTRL0_PHY_CTRL_CFG_OVR_VAL_MASK		0x0F
#define SERDES_25G_TOP_PHY_CTRL0_PHY_CTRL_CFG_OVR_VAL_SHIFT		0

#define SERDES_25G_TOP_PHY_CTRL0_OVR_EN_MASK				0x80
#define SERDES_25G_TOP_PHY_CTRL0_OVR_EN_SHIFT				7

#define SERDES_25G_TOP_PHY_CFG0_CPU_CLK_FREQ_MASK			0xFF
#define SERDES_25G_TOP_PHY_CFG0_CPU_CLK_FREQ_SHIFT			0

#define SERDES_25G_TOP_AFE_CALCOMP_CTRL0_ACAL_EN_MASK			0x0F
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL0_ACAL_EN_SHIFT			0

#define SERDES_25G_TOP_AFE_CALCOMP_CTRL1_ACAL_SEL_MASK			0x1F
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL1_ACAL_SEL_SHIFT			0

#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_EN_MASK		0x01
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_EN_SHIFT		0

#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_MUTE_MASK		0x02
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_MUTE_SHIFT		1

#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_SEL_MASK		0x04
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_SEL_SHIFT		2

#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_SPARE_MASK		0xF0
#define SERDES_25G_TOP_AFE_CALCOMP_CTRL2_CALCOMP_SPARE_SHIFT		4

#define SERDES_25G_TOP_AFE_CALCOMP_STATUS0_CALCOMP_OUT_MASK		0x01
#define SERDES_25G_TOP_AFE_CALCOMP_STATUS0_CALCOMP_OUT_SHIFT		0

#define SERDES_25G_TOP_AFE_ATEST_CTRL0_ATEST_EN_MASK			0x0F
#define SERDES_25G_TOP_AFE_ATEST_CTRL0_ATEST_EN_SHIFT			0

#define SERDES_25G_TOP_AFE_ATEST_CTRL1_ATEST_SEL_MASK			0x3F
#define SERDES_25G_TOP_AFE_ATEST_CTRL1_ATEST_SEL_SHIFT			0

#define SERDES_25G_TOP_RESET_CTRL_CM0_CORE_SW_RESET_MASK		0x01
#define SERDES_25G_TOP_RESET_CTRL_CM0_CORE_SW_RESET_SHIFT		0

#define SERDES_25G_TOP_RESET_CTRL_CM0_REG_SW_RESET_MASK			0x02
#define SERDES_25G_TOP_RESET_CTRL_CM0_REG_SW_RESET_SHIFT		1

#define SERDES_25G_TOP_RESET_CTRL_CM0_SUBCORE_SW_RESET_MASK		0x04
#define SERDES_25G_TOP_RESET_CTRL_CM0_SUBCORE_SW_RESET_SHIFT		2

#define SERDES_25G_TOP_RESET_CTRL_CM0_CAL_SW_RESET_MASK			0x40
#define SERDES_25G_TOP_RESET_CTRL_CM0_CAL_SW_RESET_SHIFT		6

#define SERDES_25G_TOP_RESET_CTRL_LN0_CORE_SW_RESET_MASK		0x01
#define SERDES_25G_TOP_RESET_CTRL_LN0_CORE_SW_RESET_SHIFT		0

#define SERDES_25G_TOP_RESET_CTRL_LN0_REG_SW_RESET_MASK			0x02
#define SERDES_25G_TOP_RESET_CTRL_LN0_REG_SW_RESET_SHIFT		1

#define SERDES_25G_TOP_RESET_CTRL_LN0_SUBCORE_SW_RESET_MASK		0x04
#define SERDES_25G_TOP_RESET_CTRL_LN0_SUBCORE_SW_RESET_SHIFT		2

#define SERDES_25G_TOP_RESET_CTRL_LN0_TXDP_SW_RESET_MASK		0x08
#define SERDES_25G_TOP_RESET_CTRL_LN0_TXDP_SW_RESET_SHIFT		3

#define SERDES_25G_TOP_RESET_CTRL_LN0_RXDP_SW_RESET_MASK		0x10
#define SERDES_25G_TOP_RESET_CTRL_LN0_RXDP_SW_RESET_SHIFT		4

#define SERDES_25G_TOP_RESET_CTRL_LN0_LOS_SW_RESET_MASK			0x20
#define SERDES_25G_TOP_RESET_CTRL_LN0_LOS_SW_RESET_SHIFT		5

#define SERDES_25G_TOP_RESET_CTRL_LN0_CAL_SW_RESET_MASK			0x40
#define SERDES_25G_TOP_RESET_CTRL_LN0_CAL_SW_RESET_SHIFT		6

#define SERDES_25G_TOP_RESET_CTRL_LN1_CORE_SW_RESET_MASK		0x01
#define SERDES_25G_TOP_RESET_CTRL_LN1_CORE_SW_RESET_SHIFT		0

#define SERDES_25G_TOP_RESET_CTRL_LN1_REG_SW_RESET_MASK			0x02
#define SERDES_25G_TOP_RESET_CTRL_LN1_REG_SW_RESET_SHIFT		1

#define SERDES_25G_TOP_RESET_CTRL_LN1_SUBCORE_SW_RESET_MASK		0x04
#define SERDES_25G_TOP_RESET_CTRL_LN1_SUBCORE_SW_RESET_SHIFT		2

#define SERDES_25G_TOP_RESET_CTRL_LN1_TXDP_SW_RESET_MASK		0x08
#define SERDES_25G_TOP_RESET_CTRL_LN1_TXDP_SW_RESET_SHIFT		3

#define SERDES_25G_TOP_RESET_CTRL_LN1_RXDP_SW_RESET_MASK		0x10
#define SERDES_25G_TOP_RESET_CTRL_LN1_RXDP_SW_RESET_SHIFT		4

#define SERDES_25G_TOP_RESET_CTRL_LN1_LOS_SW_RESET_MASK			0x20
#define SERDES_25G_TOP_RESET_CTRL_LN1_LOS_SW_RESET_SHIFT		5

#define SERDES_25G_TOP_RESET_CTRL_LN1_CAL_SW_RESET_MASK			0x40
#define SERDES_25G_TOP_RESET_CTRL_LN1_CAL_SW_RESET_SHIFT		6

#define SERDES_25G_TOP_RESET_CTRL_LN2_CORE_SW_RESET_MASK		0x01
#define SERDES_25G_TOP_RESET_CTRL_LN2_CORE_SW_RESET_SHIFT		0

#define SERDES_25G_TOP_RESET_CTRL_LN2_REG_SW_RESET_MASK			0x02
#define SERDES_25G_TOP_RESET_CTRL_LN2_REG_SW_RESET_SHIFT		1

#define SERDES_25G_TOP_RESET_CTRL_LN2_SUBCORE_SW_RESET_MASK		0x04
#define SERDES_25G_TOP_RESET_CTRL_LN2_SUBCORE_SW_RESET_SHIFT		2

#define SERDES_25G_TOP_RESET_CTRL_LN2_TXDP_SW_RESET_MASK		0x08
#define SERDES_25G_TOP_RESET_CTRL_LN2_TXDP_SW_RESET_SHIFT		3

#define SERDES_25G_TOP_RESET_CTRL_LN2_RXDP_SW_RESET_MASK		0x10
#define SERDES_25G_TOP_RESET_CTRL_LN2_RXDP_SW_RESET_SHIFT		4

#define SERDES_25G_TOP_RESET_CTRL_LN2_LOS_SW_RESET_MASK			0x20
#define SERDES_25G_TOP_RESET_CTRL_LN2_LOS_SW_RESET_SHIFT		5

#define SERDES_25G_TOP_RESET_CTRL_LN2_CAL_SW_RESET_MASK			0x40
#define SERDES_25G_TOP_RESET_CTRL_LN2_CAL_SW_RESET_SHIFT		6

#define SERDES_25G_TOP_RESET_CTRL_LN3_CORE_SW_RESET_MASK		0x01
#define SERDES_25G_TOP_RESET_CTRL_LN3_CORE_SW_RESET_SHIFT		0

#define SERDES_25G_TOP_RESET_CTRL_LN3_REG_SW_RESET_MASK			0x02
#define SERDES_25G_TOP_RESET_CTRL_LN3_REG_SW_RESET_SHIFT		1

#define SERDES_25G_TOP_RESET_CTRL_LN3_SUBCORE_SW_RESET_MASK		0x04
#define SERDES_25G_TOP_RESET_CTRL_LN3_SUBCORE_SW_RESET_SHIFT		2

#define SERDES_25G_TOP_RESET_CTRL_LN3_TXDP_SW_RESET_MASK		0x08
#define SERDES_25G_TOP_RESET_CTRL_LN3_TXDP_SW_RESET_SHIFT		3

#define SERDES_25G_TOP_RESET_CTRL_LN3_RXDP_SW_RESET_MASK		0x10
#define SERDES_25G_TOP_RESET_CTRL_LN3_RXDP_SW_RESET_SHIFT		4

#define SERDES_25G_TOP_RESET_CTRL_LN3_LOS_SW_RESET_MASK			0x20
#define SERDES_25G_TOP_RESET_CTRL_LN3_LOS_SW_RESET_SHIFT		5

#define SERDES_25G_TOP_RESET_CTRL_LN3_CAL_SW_RESET_MASK			0x40
#define SERDES_25G_TOP_RESET_CTRL_LN3_CAL_SW_RESET_SHIFT		6

#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_CTRL_SRC_SEL_MASK		0x01
#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_STAT_DEFAULT_CLK_EN_MASK	0x02
#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_STAT_DEFAULT_CLK_EN_SHIFT	1

#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_STAT_REF_CLK_EN_MASK	0x04
#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_STAT_REF_CLK_EN_SHIFT	2

#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_AFE_CM0_CLK_REF_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_CM0_CLK_REF_CTRL_DIV_SEL_MASK		0x01
#define SERDES_25G_TOP_CLOCK_CM0_CLK_REF_CTRL_DIV_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_CM0_CLK_REF_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_CM0_CLK_REF_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_CM0_REFCLK_CTRL_CG_EN_MASK			0x01
#define SERDES_25G_TOP_CLOCK_CM0_REFCLK_CTRL_CG_EN_SHIFT		0

#define SERDES_25G_TOP_CLOCK_CM0_REFCLK_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_CM0_REFCLK_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_CM0_CLK_SSC_GEN_CTRL_DIV_SEL_MASK		0x07
#define SERDES_25G_TOP_CLOCK_CM0_CLK_SSC_GEN_CTRL_DIV_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_CM0_CLK_SSC_GEN_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_CM0_CLK_SSC_GEN_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_CM0_CLK_GCFSM_CTRL_DIV_SEL_MASK		0x07
#define SERDES_25G_TOP_CLOCK_CM0_CLK_GCFSM_CTRL_DIV_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_CM0_CLK_GCFSM_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_CM0_CLK_GCFSM_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMPLL_VCO_CTRL_DIV_SEL_MASK	0x01
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMPLL_VCO_CTRL_DIV_SEL_SHIFT	0

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMPLL_VCO_CTRL_CG_EN_MASK		0x02
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMPLL_VCO_CTRL_CG_EN_SHIFT		1

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMPLL_VCO_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMPLL_VCO_CTRL_TBUS_OUT_CG_EN_SHIFT 7

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_CTRL_SRC_SEL_MASK		0x01
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_STAT_DEFAULT_CLK_EN_MASK	0x02
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_STAT_DEFAULT_CLK_EN_SHIFT	1

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_STAT_CMU_CLK_EN_MASK		0x04
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_STAT_CMU_CLK_EN_SHIFT		2

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_CTRL_DIV_SEL_MASK		0xF8
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_CTRL_DIV_SEL_SHIFT		3

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_CTRL1_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMU_CTRL1_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_CTRL_SRC_SEL_MASK           0x01
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_CTRL_SRC_SEL_SHIFT          0

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_STAT_DEFAULT_CLK_EN_MASK    0x02
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_STAT_DEFAULT_CLK_EN_SHIFT   1

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_STAT_CMUDIV_CLK_EN_MASK     0x04
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_STAT_CMUDIV_CLK_EN_SHIFT    2

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_CTRL_DIV_SEL_MASK           0xF8
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_CTRL_DIV_SEL_SHIFT          3

#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_CTRL1_TBUS_OUT_CG_EN_MASK   0x80
#define SERDES_25G_TOP_CLOCK_CM0_CLK_CMUDIV_CTRL1_TBUS_OUT_CG_EN_SHIFT  7

#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_FRCDIV_MODE_EN_MASK	0x01
#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_FRCDIV_MODE_EN_SHIFT 0

#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_SRC_SEL_MASK	0x06
#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_SRC_SEL_SHIFT	1

#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_DIV_SEL_MASK	0x08
#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_DIV_SEL_SHIFT	3

#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_CM0_CLK_FRACN_FBK_CTRL_TBUS_OUT_CG_EN_SHIFT 7

#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_DIV_SEL_MASK		0x04
#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_DIV_SEL_SHIFT		2

#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_BIST_CG_EN_MASK		0x10
#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_BIST_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN0_CLK_TX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_CTRL_SRC_SEL_MASK		0x01
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_STAT_DEFAULT_CLK_EN_MASK	0x02
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_STAT_DEFAULT_CLK_EN_SHIFT	1

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_STAT_RX_CLK_EN_MASK		0x04
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_STAT_RX_CLK_EN_SHIFT	2

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_CG_EN_MASK			0x10
#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_BIST_CG_EN_MASK		0x20
#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_BIST_CG_EN_SHIFT		5

#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN0_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_CTRL_SRC_SEL_MASK           0x01
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_CTRL_SRC_SEL_SHIFT          0

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_STAT_DEFAULT_CLK_EN_MASK    0x02
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_STAT_DEFAULT_CLK_EN_SHIFT   1

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_STAT_RX_CLKDIV_EN_MASK      0x04
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_STAT_RX_CLKDIV_EN_SHIFT     2

#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_CTRL_TBUS_OUT_CG_EN_MASK    0x80
#define SERDES_25G_TOP_CLOCK_AFE_LN0_CLK_RXDIV_CORE_CTRL_TBUS_OUT_CG_EN_SHIFT   7

#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_DIV_SEL_MASK		0x04
#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_DIV_SEL_SHIFT		2

#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_BIST_CG_EN_MASK		0x10
#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_BIST_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN1_CLK_TX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_CTRL_SRC_SEL_MASK		0x01
#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_STAT_DEFAULT_CLK_EN_MASK	0x02
#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_STAT_DEFAULT_CLK_EN_SHIFT	1

#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_STAT_RX_CLK_EN_MASK		0x04
#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_STAT_RX_CLK_EN_SHIFT	2

#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_AFE_LN1_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_CG_EN_MASK			0x10
#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_BIST_CG_EN_MASK		0x20
#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_BIST_CG_EN_SHIFT		5

#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN1_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_DIV_SEL_MASK		0x04
#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_DIV_SEL_SHIFT		2

#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_BIST_CG_EN_MASK		0x10
#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_BIST_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN2_CLK_TX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_CTRL_SRC_SEL_MASK		0x01
#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_STAT_DEFAULT_CLK_EN_MASK	0x02
#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_STAT_DEFAULT_CLK_EN_SHIFT	1

#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_STAT_RX_CLK_EN_MASK		0x04
#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_STAT_RX_CLK_EN_SHIFT	2

#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_AFE_LN2_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_CG_EN_MASK			0x10
#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_BIST_CG_EN_MASK		0x20
#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_BIST_CG_EN_SHIFT		5

#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN2_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_DIV_SEL_MASK		0x04
#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_DIV_SEL_SHIFT		2

#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_BIST_CG_EN_MASK		0x10
#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_BIST_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN3_CLK_TX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_CTRL_SRC_SEL_MASK		0x01
#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_STAT_DEFAULT_CLK_EN_MASK	0x02
#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_STAT_DEFAULT_CLK_EN_SHIFT	1

#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_STAT_RX_CLK_EN_MASK		0x04
#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_STAT_RX_CLK_EN_SHIFT	2

#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_AFE_LN3_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_SRC_SEL_MASK		0x03
#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_SRC_SEL_SHIFT		0

#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_CG_EN_MASK			0x10
#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_CG_EN_SHIFT		4

#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_BIST_CG_EN_MASK		0x20
#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_BIST_CG_EN_SHIFT		5

#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_TBUS_OUT_CG_EN_MASK	0x80
#define SERDES_25G_TOP_CLOCK_LN3_CLK_RX_CTRL_TBUS_OUT_CG_EN_SHIFT	7

#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN0_MASK				0x01
#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN0_SHIFT			0

#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN1_MASK				0x02
#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN1_SHIFT			1

#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN2_MASK				0x04
#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN2_SHIFT			2

#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN3_MASK				0x08
#define SERDES_25G_TOP_LOS_INT_EN_CTRL_LN3_SHIFT			3

#define SERDES_25G_TOP_REGBUS_TIMER_LOAD_VAL_MASK			0xFF
#define SERDES_25G_TOP_REGBUS_TIMER_LOAD_VAL_SHIFT			0

#define SERDES_25G_TOP_ERR_CTRL0_ERR_MASK				0x01
#define SERDES_25G_TOP_ERR_CTRL0_ERR_SHIFT				0

#define SERDES_25G_TOP_ERR_CTRL1_ERR_CODE_7_0_MASK			0xFF
#define SERDES_25G_TOP_ERR_CTRL1_ERR_CODE_7_0_SHIFT			0

#define SERDES_25G_TOP_ERR_CTRL2_ERR_CODE_15_8_MASK			0xFF
#define SERDES_25G_TOP_ERR_CTRL2_ERR_CODE_15_8_SHIFT			0

#define SERDES_25G_TOP_ERR_STATUS0_REGBUS_ERR_MASK			0x01
#define SERDES_25G_TOP_ERR_STATUS0_REGBUS_ERR_SHIFT			0

#define SERDES_25G_TOP_REGBUS_ERR_INFO_CTRL_CLR_MASK			0x01
#define SERDES_25G_TOP_REGBUS_ERR_INFO_CTRL_CLR_SHIFT			0

#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS0_ERR_TYPE_MASK		0x03
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS0_ERR_TYPE_SHIFT		0

#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS0_TRANSFER_RW_MASK		0x04
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS0_TRANSFER_RW_SHIFT	2

#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS1_TRANSFER_ADDR_LSB_MASK	0xFF
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS1_TRANSFER_ADDR_LSB_SHIFT	0

#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS2_TRANSFER_ADDR_MSB_MASK	0x7F
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS2_TRANSFER_ADDR_MSB_SHIFT	0

#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS3_TRANSFER_WD_MASK		0xFF
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS3_TRANSFER_WD_SHIFT	0

#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS4_TRANSFER_WR_BIT_EN_MASK	0xFF
#define SERDES_25G_TOP_REGBUS_ERR_INFO_STATUS4_TRANSFER_WR_BIT_EN_SHIFT	0

#define SERDES_25G_TOP_TBUS_ADDR_7_0_MASK				0xFF
#define SERDES_25G_TOP_TBUS_ADDR_7_0_SHIFT				0

#define SERDES_25G_TOP_TBUS_ADDR_15_8_MASK				0xFF
#define SERDES_25G_TOP_TBUS_ADDR_15_8_SHIFT				0

#define SERDES_25G_TOP_TBUS_CTRL0_CLOCK_GATE0_MASK			0xFF
#define SERDES_25G_TOP_TBUS_CTRL0_CLOCK_GATE0_SHIFT			0

#define SERDES_25G_TOP_TBUS_CTRL1_CLOCK_GATE1_MASK			0xFF
#define SERDES_25G_TOP_TBUS_CTRL1_CLOCK_GATE1_SHIFT			0

#define SERDES_25G_TOP_TBUS_DATA_7_0_MASK				0xFF
#define SERDES_25G_TOP_TBUS_DATA_7_0_SHIFT				0

#define SERDES_25G_TOP_TBUS_DATA_11_8_MASK				0x0F
#define SERDES_25G_TOP_TBUS_DATA_11_8_SHIFT				0

/*********************************** Mailbox **********************************/
#define SERDES_25G_TOP_MB_BASE						0x200

#define SERDES_25G_TOP_CMD_ADDR			(SERDES_25G_TOP_MB_BASE +  0x00)
#define SERDES_25G_TOP_CMD_FLAG_ADDR		(SERDES_25G_TOP_MB_BASE +  0x02)
#define SERDES_25G_TOP_CMD_DATA0_ADDR		(SERDES_25G_TOP_MB_BASE +  0x03)
#define SERDES_25G_TOP_CMD_DATA1_ADDR		(SERDES_25G_TOP_MB_BASE +  0x04)
#define SERDES_25G_TOP_CMD_DATA2_ADDR		(SERDES_25G_TOP_MB_BASE +  0x05)
#define SERDES_25G_TOP_CMD_DATA3_ADDR		(SERDES_25G_TOP_MB_BASE +  0x06)
#define SERDES_25G_TOP_CMD_DATA4_ADDR		(SERDES_25G_TOP_MB_BASE +  0x07)
#define SERDES_25G_TOP_CMD_DATA5_ADDR		(SERDES_25G_TOP_MB_BASE +  0x08)
#define SERDES_25G_TOP_CMD_DATA6_ADDR		(SERDES_25G_TOP_MB_BASE +  0x09)
#define SERDES_25G_TOP_CMD_DATA7_ADDR		(SERDES_25G_TOP_MB_BASE +  0x0A)
#define SERDES_25G_TOP_RSP_ADDR			(SERDES_25G_TOP_MB_BASE +  0x10)
#define SERDES_25G_TOP_RSP_FLAG_ADDR		(SERDES_25G_TOP_MB_BASE +  0x12)
#define SERDES_25G_TOP_RSP_DATA0_ADDR		(SERDES_25G_TOP_MB_BASE +  0x13)
#define SERDES_25G_TOP_RSP_DATA1_ADDR		(SERDES_25G_TOP_MB_BASE +  0x14)
#define SERDES_25G_TOP_RSP_DATA2_ADDR		(SERDES_25G_TOP_MB_BASE +  0x15)
#define SERDES_25G_TOP_RSP_DATA3_ADDR		(SERDES_25G_TOP_MB_BASE +  0x16)
#define SERDES_25G_TOP_RSP_DATA4_ADDR		(SERDES_25G_TOP_MB_BASE +  0x17)
#define SERDES_25G_TOP_RSP_DATA5_ADDR		(SERDES_25G_TOP_MB_BASE +  0x18)
#define SERDES_25G_TOP_RSP_DATA6_ADDR		(SERDES_25G_TOP_MB_BASE +  0x19)
#define SERDES_25G_TOP_RSP_DATA7_ADDR		(SERDES_25G_TOP_MB_BASE +  0x1A)
#define SERDES_25G_TOP_RSP_DATA8_ADDR		(SERDES_25G_TOP_MB_BASE +  0x1B)
#define SERDES_25G_TOP_RSP_DATA9_ADDR		(SERDES_25G_TOP_MB_BASE +  0x1C)
#define SERDES_25G_TOP_RSP_DATA10_ADDR		(SERDES_25G_TOP_MB_BASE +  0x1D)
#define SERDES_25G_TOP_RSP_DATA11_ADDR		(SERDES_25G_TOP_MB_BASE +  0x1E)
#define SERDES_25G_TOP_RSP_DATA12_ADDR		(SERDES_25G_TOP_MB_BASE +  0x1F)
#define SERDES_25G_TOP_RSP_DATA13_ADDR		(SERDES_25G_TOP_MB_BASE +  0x20)
#define SERDES_25G_TOP_RSP_DATA14_ADDR		(SERDES_25G_TOP_MB_BASE +  0x21)
#define SERDES_25G_TOP_RSP_DATA15_ADDR		(SERDES_25G_TOP_MB_BASE +  0x22)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_TOP_CMD_MASK						0xFF
#define SERDES_25G_TOP_CMD_SHIFT					0

#define SERDES_25G_TOP_CMD_FLAG_MASK					0x01
#define SERDES_25G_TOP_CMD_FLAG_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA0_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA0_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA1_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA1_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA2_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA2_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA3_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA3_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA4_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA4_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA5_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA5_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA6_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA6_SHIFT					0

#define SERDES_25G_TOP_CMD_DATA7_MASK					0xFF
#define SERDES_25G_TOP_CMD_DATA7_SHIFT					0

#define SERDES_25G_TOP_RSP_MASK						0xFF
#define SERDES_25G_TOP_RSP_SHIFT					0

#define SERDES_25G_TOP_RSP_FLAG_MASK					0x01
#define SERDES_25G_TOP_RSP_FLAG_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA0_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA0_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA1_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA1_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA2_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA2_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA3_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA3_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA4_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA4_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA5_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA5_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA6_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA6_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA7_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA7_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA8_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA8_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA9_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA9_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA10_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA10_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA11_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA11_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA12_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA12_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA13_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA13_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA14_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA14_SHIFT					0

#define SERDES_25G_TOP_RSP_DATA15_MASK					0xFF
#define SERDES_25G_TOP_RSP_DATA15_SHIFT					0

/*******************************************************************************
 * Common Registers
 ******************************************************************************/
#define SERDES_25G_CM_BASE						0xC00
#define SERDES_25G_CM_SIZE						0x400

#define SERDES_25G_CM_TOP_AFE_PD_CTRL0_ADDR				0x00
#define SERDES_25G_CM_TOP_AFE_PD_CTRL1_ADDR				0x01
#define SERDES_25G_CM_TOP_AFE_RST_CTRL0_ADDR				0x03
#define SERDES_25G_CM_TOP_AFE_BIAS_CTRL0_ADDR				0x05
#define SERDES_25G_CM_TOP_AFE_BIAS_CTRL1_ADDR				0x06
#define SERDES_25G_CM_TOP_AFE_BIAS_CTRL2_ADDR				0x07
#define SERDES_25G_CM_TOP_AFE_BIAS_CTRL3_ADDR				0x08
#define SERDES_25G_CM_TOP_AFE_BIAS_CTRL4_ADDR				0x09
#define SERDES_25G_CM_TOP_AFE_BIAS_CTRL5_ADDR				0x0A
#define SERDES_25G_CM_TOP_AFE_REG_CTRL0_ADDR				0x0C
#define SERDES_25G_CM_TOP_AFE_REFCLK_CTRL0_ADDR				0x1A
#define SERDES_25G_CM_TOP_AFE_REFCLK_CTRL1_ADDR				0x1B
#define SERDES_25G_CM_TOP_AFE_REFCLK_CTRL2_ADDR				0x1F
#define SERDES_25G_CM_TOP_AFE_CMCP_CTRL0_ADDR				0x20
#define SERDES_25G_CM_TOP_AFE_CMCP_CTRL1_ADDR				0x21
#define SERDES_25G_CM_TOP_AFE_CMCP_CTRL2_ADDR				0x22
#define SERDES_25G_CM_TOP_AFE_MISC_CTRL0_ADDR				0x23
#define SERDES_25G_CM_TOP_AFE_CMCP_STATUS_ADDR				0x24
#define SERDES_25G_CM_TOP_AFE_TOGGLE_CTRL0_ADDR				0x25
#define SERDES_25G_CM_TOP_AFE_TSTCLK_CTRL0_ADDR				0x28
#define SERDES_25G_CM_TOP_AFE_TXTC_CTRL0_ADDR				0x30
#define SERDES_25G_CM_TOP_AFE_TXTC_CTRL1_ADDR				0x31
#define SERDES_25G_CM_TOP_AFE_TXTC_CTRL2_ADDR				0x32
#define SERDES_25G_CM_TOP_AFE_TXTC_CTRL3_ADDR				0x33
#define SERDES_25G_CM_TOP_AFE_TXTC_CTRL4_ADDR				0x34
#define SERDES_25G_CM_TOP_PWR_STATE_REQ_STATUS_ADDR			0x50
#define SERDES_25G_CM_TOP_PWR_STATE_ACK_CTRL_ADDR			0x51
#define SERDES_25G_CM_TOP_PHY_IF_STATUS_ADDR				0x52
#define SERDES_25G_CM_TOP_CMU_TOP_SPARE0_ADDR				0x58
#define SERDES_25G_CM_TOP_CMU_TOP_SPARE1_ADDR				0x59
#define SERDES_25G_CM_TOP_ERR_CTRL1_ADDR				0x80
#define SERDES_25G_CM_TOP_ERR_CTRL2_ADDR				0x81
#define SERDES_25G_CM_TOP_ERR_CTRL3_ADDR				0x82
#define SERDES_25G_CM_TOP_CMU_IF_OVR_CTRL0_ADDR				0x8A
#define SERDES_25G_CM_TOP_CMU_IF_OVR_CTRL1_ADDR				0x8B
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_MASK			 0x01
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_SHIFT			 0

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_ICV_MASK		 0x02
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_ICV_SHIFT		 1

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_ICC_MASK		 0x04
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_ICC_SHIFT		 2

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_IPTAT_MASK		 0x08
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_IPTAT_SHIFT		 3

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_SLAVE_MASK		 0x10
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_BIAS_SLAVE_SHIFT		 4

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_REG_REF_MASK			 0x20
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_REG_REF_SHIFT		 5

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_REFCLK_MASK			 0x40
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL0_PD_REFCLK_SHIFT			 6

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL1_PD_CMCP_MASK			 0x01
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL1_PD_CMCP_SHIFT			 0

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL1_PD_CMCP_TXCLK_LEFT_MASK		 0x02
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL1_PD_CMCP_TXCLK_LEFT_SHIFT	 1

#define SERDES_25G_CMU_TOP_AFE_PD_CTRL1_PD_CMCP_TXCLK_RIGHT_MASK	 0x04
#define SERDES_25G_CMU_TOP_AFE_PD_CTRL1_PD_CMCP_TXCLK_RIGHT_SHIFT	 2

#define SERDES_25G_CMU_TOP_AFE_RST_CTRL0_RST_CMCP_CLK_CMU_N_MASK	 0x01
#define SERDES_25G_CMU_TOP_AFE_RST_CTRL0_RST_CMCP_CLK_CMU_N_SHIFT	 0

#define SERDES_25G_CMU_TOP_AFE_RST_CTRL0_RST_CMCP_CLK_CMUDIV_N_MASK	 0x02
#define SERDES_25G_CMU_TOP_AFE_RST_CTRL0_RST_CMCP_CLK_CMUDIV_N_SHIFT	 1

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL0_BIAS_ICV_TRIM_MASK		 0x0F
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL0_BIAS_ICV_TRIM_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL0_BIAS_ICC_TRIM_MASK		 0xF0
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL0_BIAS_ICC_TRIM_SHIFT		 4

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL1_BIAS_IPTAT_TRIM_MASK		 0x0F
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL1_BIAS_IPTAT_TRIM_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL2_BIAS_BGSTART_BYP_MASK		 0x01
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL2_BIAS_BGSTART_BYP_SHIFT	 0

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL2_BIAS_IPTATSTART_BYP_MASK	 0x02
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL2_BIAS_IPTATSTART_BYP_SHIFT	 1

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL2_TERMCAL_EN_MASK		 0x04
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL2_TERMCAL_EN_SHIFT		 2

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL3_TERMCAL_PTRIM_MASK		 0x0F
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL3_TERMCAL_PTRIM_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL3_TERMCAL_NTRIM_MASK		 0xF0
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL3_TERMCAL_NTRIM_SHIFT		 4

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL4_BIAS_SPARE_MASK		 0x0F
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL4_BIAS_SPARE_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL5_BIAS_CALREF_TRIM_MASK		 0x0F
#define SERDES_25G_CMU_TOP_AFE_BIAS_CTRL5_BIAS_CALREF_TRIM_SHIFT	 0

#define SERDES_25G_CMU_TOP_AFE_REG_CTRL0_REG_REF_PASS_EN_MASK		 0x01
#define SERDES_25G_CMU_TOP_AFE_REG_CTRL0_REG_REF_PASS_EN_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_REG_CTRL0_REG_REF_TRIM_MASK		 0x0E
#define SERDES_25G_CMU_TOP_AFE_REG_CTRL0_REG_REF_TRIM_SHIFT		 1

#define SERDES_25G_CMU_TOP_AFE_REG_CTRL0_REG_REF_TRICKLE_MASK		 0x30
#define SERDES_25G_CMU_TOP_AFE_REG_CTRL0_REG_REF_TRICKLE_SHIFT		 4

#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL0_REFCLK_DIV_MASK		 0x03
#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL0_REFCLK_DIV_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL0_REFCLK_DPL_DIV_MASK		 0x0C
#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL0_REFCLK_DPL_DIV_SHIFT	 2

#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL0_REFCLK_DEGLITCH_OVR_MASK	 0x10
#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL0_REFCLK_DEGLITCH_OVR_SHIFT	 4

#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL1_REFCLK_TERM_MASK		 0x1F
#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL1_REFCLK_TERM_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL2_REFCLK_SPARE_MASK		 0x0F
#define SERDES_25G_CMU_TOP_AFE_REFCLK_CTRL2_REFCLK_SPARE_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_QSAMPLE_EN_MASK		 0x01
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_QSAMPLE_EN_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_DCD_RANGE_MASK		 0x02
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_DCD_RANGE_SHIFT		 1

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_CMUCLK_DIV_MASK		 0x1C
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_CMUCLK_DIV_SHIFT		 2

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_CMUDIVCLK_DIV_MASK	 0xE0
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL0_CMCP_CMUDIVCLK_DIV_SHIFT	 5

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL1_CMCP_CLKDIV_SWING_MASK	 0x03
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL1_CMCP_CLKDIV_SWING_SHIFT	 0

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL1_CMCP_TXCLK_SWING_MASK		 0x0C
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL1_CMCP_TXCLK_SWING_SHIFT	 2

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL1_CMCP_CMUCLK_DIV2_BYPASS_MASK	 0x10
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL1_CMCP_CMUCLK_DIV2_BYPASS_SHIFT	 4

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_CLKDIV_OVR_MASK		 0x03
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_CLKDIV_OVR_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_TXCLK_BIASI_MASK		 0x0C
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_TXCLK_BIASI_SHIFT	 2

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_TXCLK_DIV_MASK		 0x70
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_TXCLK_DIV_SHIFT		 4

#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_DIV1P5_DUMMY_EN_MASK	 0x80
#define SERDES_25G_CMU_TOP_AFE_CMCP_CTRL2_CMCP_DIV1P5_DUMMY_EN_SHIFT	 7

#define SERDES_25G_CMU_TOP_AFE_MISC_CTRL0_CMCP_SPARE_MASK		 0xFF
#define SERDES_25G_CMU_TOP_AFE_MISC_CTRL0_CMCP_SPARE_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_CMCP_STATUS_CMCP_DIV1P5_QSAMPLE_MASK	 0x0F
#define SERDES_25G_CMU_TOP_AFE_CMCP_STATUS_CMCP_DIV1P5_QSAMPLE_SHIFT	 0

#define SERDES_25G_CMU_TOP_AFE_TOGGLE_CTRL0_CLK_TOGGLE_EN_MASK		 0x01
#define SERDES_25G_CMU_TOP_AFE_TOGGLE_CTRL0_CLK_TOGGLE_EN_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_TOGGLE_CTRL0_CMCP_TOGGLE_EN_MASK		 0x02
#define SERDES_25G_CMU_TOP_AFE_TOGGLE_CTRL0_CMCP_TOGGLE_EN_SHIFT	 1

#define SERDES_25G_CMU_TOP_AFE_TSTCLK_CTRL0_CMCP_TSTCLK_MUX_MASK	 0x03
#define SERDES_25G_CMU_TOP_AFE_TSTCLK_CTRL0_CMCP_TSTCLK_MUX_SHIFT	 0

#define SERDES_25G_CMU_TOP_AFE_TSTCLK_CTRL0_CMCP_TSTCLK_DIV_MASK	 0x1C
#define SERDES_25G_CMU_TOP_AFE_TSTCLK_CTRL0_CMCP_TSTCLK_DIV_SHIFT	 2

#define SERDES_25G_CMU_TOP_AFE_TSTCLK_CTRL0_CMCP_TSTCLK_SWING_MASK	 0x60
#define SERDES_25G_CMU_TOP_AFE_TSTCLK_CTRL0_CMCP_TSTCLK_SWING_SHIFT	 5

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL0_TXTC_CALN_X1_MASK		 0x07
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL0_TXTC_CALN_X1_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL0_TXTC_CALN_X1_FIXED_MASK	 0x18
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL0_TXTC_CALN_X1_FIXED_SHIFT	 3

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL1_TXTC_CALN_X2_MASK		 0x1F
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL1_TXTC_CALN_X2_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL1_TXTC_CALN_XP5_FIXED_MASK	 0x60
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL1_TXTC_CALN_XP5_FIXED_SHIFT	 5

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL2_TXTC_CALP_X1_MASK		 0x07
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL2_TXTC_CALP_X1_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL2_TXTC_CALP_X1_FIXED_MASK	 0x18
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL2_TXTC_CALP_X1_FIXED_SHIFT	 3

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL3_TXTC_CALP_X2_MASK		 0x1F
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL3_TXTC_CALP_X2_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL3_TXTC_CALP_XP5_FIXED_MASK	 0x60
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL3_TXTC_CALP_XP5_FIXED_SHIFT	 5

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL4_TXTC_TERM_NEG_MASK		 0x07
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL4_TXTC_TERM_NEG_SHIFT		 0

#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL4_TXTC_TERM_POS_MASK		 0x70
#define SERDES_25G_CMU_TOP_AFE_TXTC_CTRL4_TXTC_TERM_POS_SHIFT		 4

#define SERDES_25G_CMU_TOP_PWR_STATE_REQ_STATUS_STATE_MASK		 0x07
#define SERDES_25G_CMU_TOP_PWR_STATE_REQ_STATUS_STATE_SHIFT		 0

#define SERDES_25G_CMU_TOP_PWR_STATE_REQ_STATUS_REQ_MASK		 0x08
#define SERDES_25G_CMU_TOP_PWR_STATE_REQ_STATUS_REQ_SHIFT		 3

#define SERDES_25G_CMU_TOP_PWR_STATE_ACK_CTRL_STATE_MASK		 0x07
#define SERDES_25G_CMU_TOP_PWR_STATE_ACK_CTRL_STATE_SHIFT		 0

#define SERDES_25G_CMU_TOP_PWR_STATE_ACK_CTRL_ACK_MASK			 0x08
#define SERDES_25G_CMU_TOP_PWR_STATE_ACK_CTRL_ACK_SHIFT			 3

#define SERDES_25G_CMU_TOP_PWR_STATE_ACK_CTRL_DELAY_LEN_MASK		 0x70
#define SERDES_25G_CMU_TOP_PWR_STATE_ACK_CTRL_DELAY_LEN_SHIFT		 4

#define SERDES_25G_CMU_TOP_PHY_IF_STATUS_CMU_OK_MASK			 0x01
#define SERDES_25G_CMU_TOP_PHY_IF_STATUS_CMU_OK_SHIFT			 0

#define SERDES_25G_CMU_TOP_CMU_TOP_SPARE0_MASK				 0xFF
#define SERDES_25G_CMU_TOP_CMU_TOP_SPARE0_SHIFT				 0

#define SERDES_25G_CMU_TOP_CMU_TOP_SPARE1_MASK				 0xFF
#define SERDES_25G_CMU_TOP_CMU_TOP_SPARE1_SHIFT				 0

#define SERDES_25G_CMU_TOP_ERR_CTRL1_ERR_CODE_7_0_MASK			 0xFF
#define SERDES_25G_CMU_TOP_ERR_CTRL1_ERR_CODE_7_0_SHIFT			 0

#define SERDES_25G_CMU_TOP_ERR_CTRL2_ERR_CODE_15_8_MASK			 0xFF
#define SERDES_25G_CMU_TOP_ERR_CTRL2_ERR_CODE_15_8_SHIFT		 0

#define SERDES_25G_CMU_TOP_ERR_CTRL3_CMU_ERR__MASK			 0x01
#define SERDES_25G_CMU_TOP_ERR_CTRL3_CMU_ERR__SHIFT			 0

#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL0_CMU_PD_OVR_EN_MASK		 0x01
#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL0_CMU_PD_OVR_EN_SHIFT		 0

#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL0_CMU_PD_OVR_VAL_MASK		 0x06
#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL0_CMU_PD_OVR_VAL_SHIFT	 1

#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL1_CMU_RST_N_OVR_EN_MASK	 0x01
#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL1_CMU_RST_N_OVR_EN_SHIFT	 0

#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL1_CMU_RST_N_OVR_VAL_MASK	 0x02
#define SERDES_25G_CMU_TOP_CMU_IF_OVR_CTRL1_CMU_RST_N_OVR_VAL_SHIFT	 1


/*******************************************************************************
 * Lane Registers
 ******************************************************************************/
#define SERDES_25G_LANE_BASE						0x1800
#define SERDES_25G_LANE_SIZE						0x800

/********************************** LANE_TOP **********************************/
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_ADDR			 0x00
#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_ADDR				 0x01
#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_ADDR				 0x02
#define SERDES_25G_LANE_TOP_AFE_BIAS_PD_CTRL_ADDR			 0x03
#define SERDES_25G_LANE_TOP_AFE_RX_RST_CTRL_ADDR			 0x04
#define SERDES_25G_LANE_TOP_AFE_TX_RST_CTRL_ADDR			 0x05
#define SERDES_25G_LANE_TOP_AFE_BIAS_CTRL_ADDR				 0x06
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_ADDR				 0x10
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_ADDR				 0x12
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL3_ADDR				 0x13
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_ADDR				 0x14
#define SERDES_25G_LANE_TOP_AFE_TXDP_CTRL0_ADDR				 0x16
#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_ADDR				 0x19
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_ADDR			 0x1B
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL1_ADDR			 0x1C
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_ADDR				 0x22
#define SERDES_25G_LANE_TOP_DPL_RXDP_CTRL1_ADDR				 0x24
#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_ADDR			 0x25
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_ADDR			 0x26
#define SERDES_25G_LANE_TOP_PHY_IF_STATUS_ADDR				 0x27
#define SERDES_25G_LANE_TOP_DELAY_CTRL0_ADDR				 0x30
#define SERDES_25G_LANE_TOP_DELAY_CTRL1_ADDR				 0x31
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL0_ADDR				 0x38
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_ADDR			 0x39
#define SERDES_25G_LANE_TOP_LN_STAT_STATUS0_ADDR			 0x3A
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_ADDR				 0x3B
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_ADDR				 0x3C
#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_ADDR			 0x3D
#define SERDES_25G_LANE_TOP_ERR_CTRL1_ADDR				 0x40
#define SERDES_25G_LANE_TOP_ERR_CTRL2_ADDR				 0x41
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_RXCLK_EN_MASK     0x01
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_RXCLK_EN_SHIFT    0

#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_TXCLK_EN_MASK     0x02
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_TXCLK_EN_SHIFT    1

#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_FEA_EN_MASK       0x04
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_FEA_EN_SHIFT      2

#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_NEA_EN_MASK       0x08
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_NEA_EN_SHIFT      3

#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXTERM_MASK                0x01
#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXTERM_SHIFT               0

#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXDP_MASK                  0x02
#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXDP_SHIFT                 1

#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_REG_TXCP_MASK              0x01
#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_REG_TXCP_SHIFT             0

#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_TXCP_MASK                  0x02
#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_TXCP_SHIFT                 1

#define SERDES_25G_LANE_TOP_AFE_BIAS_PD_CTRL_PD_BIAS_LANE_MASK           0x01
#define SERDES_25G_LANE_TOP_AFE_BIAS_PD_CTRL_PD_BIAS_LANE_SHIFT          0

#define SERDES_25G_LANE_TOP_AFE_RX_RST_CTRL_RST_RXDP_N_MASK              0x01
#define SERDES_25G_LANE_TOP_AFE_RX_RST_CTRL_RST_RXDP_N_SHIFT             0

#define SERDES_25G_LANE_TOP_AFE_TX_RST_CTRL_RST_TXDP_N_MASK              0x04
#define SERDES_25G_LANE_TOP_AFE_TX_RST_CTRL_RST_TXDP_N_SHIFT             2

#define SERDES_25G_LANE_TOP_AFE_BIAS_CTRL_BIAS_SPARE_MASK                0x0F
#define SERDES_25G_LANE_TOP_AFE_BIAS_CTRL_BIAS_SPARE_SHIFT               0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRIM_MASK            0x0F
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRIM_SHIFT           0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRICKLE_MASK         0x30
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRICKLE_SHIFT        4

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_PASS_EN_MASK         0x40
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_PASS_EN_SHIFT        6

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_TSTCLK_EN_MASK           0x01
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_TSTCLK_EN_SHIFT          0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_CLKDIV_MASK              0x06
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_CLKDIV_SHIFT             1

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL3_TXCP_SPARE_MASK               0x0F
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL3_TXCP_SPARE_SHIFT              0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_CLKDIV_SWING_MASK        0x03
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_CLKDIV_SWING_SHIFT       0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_TOGGLE_EN_MASK           0x04
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_TOGGLE_EN_SHIFT          2

#define SERDES_25G_LANE_TOP_AFE_TXDP_CTRL0_TXDP_SPARE_MASK               0xF0
#define SERDES_25G_LANE_TOP_AFE_TXDP_CTRL0_TXDP_SPARE_SHIFT              4

#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_CLKDLY_MASK              0x07
#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_CLKDLY_SHIFT             0

#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_SPARE_MASK               0xF0
#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_SPARE_SHIFT              4

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_CMFILT_MASK          0x07
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_CMFILT_SHIFT         0

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_HIZ_MASK             0x08
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_HIZ_SHIFT            3

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_VCM_GND_MASK         0x10
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_VCM_GND_SHIFT        4

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL1_RXTERM_VAL_MASK             0x1F
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL1_RXTERM_VAL_SHIFT            0

#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_SEL_MASK             0x03
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_SEL_SHIFT            0

#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_TXPOLARITY_MASK               0x04
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_TXPOLARITY_SHIFT              2

#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_LB_FED_TX_EN_MASK    0x10
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_LB_FED_TX_EN_SHIFT   4

#define SERDES_25G_LANE_TOP_DPL_RXDP_CTRL1_DMUX_RX_SEL_MASK              0x01
#define SERDES_25G_LANE_TOP_DPL_RXDP_CTRL1_DMUX_RX_SEL_SHIFT             0

#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_STATE_MASK              0x07
#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_STATE_SHIFT             0

#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_REQ_MASK                0x08
#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_REQ_SHIFT               3

#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_STATE_MASK                0x07
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_STATE_SHIFT               0

#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_ACK_MASK                  0x08
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_ACK_SHIFT                 3

#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_DELAY_LEN_MASK            0x70
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_DELAY_LEN_SHIFT           4

#define SERDES_25G_LANE_TOP_PHY_IF_STATUS_LN_OK_MASK                     0x01
#define SERDES_25G_LANE_TOP_PHY_IF_STATUS_LN_OK_SHIFT                    0

#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_DATA_EDELAY_MASK              0x07
#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_DATA_EDELAY_SHIFT             0

#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_EDGE_DELAY_MASK               0x38
#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_EDGE_DELAY_SHIFT              3

#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_DATA_IDELAY_MASK              0x07
#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_DATA_IDELAY_SHIFT             0

#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_EYE_DELAY_MASK                0x38
#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_EYE_DELAY_SHIFT               3

#define SERDES_25G_LANE_TOP_LN_STAT_CTRL0_RXVALID_MASK                   0x01
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL0_RXVALID_SHIFT                  0

#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_OVR_EN_MASK                 0x01
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_OVR_EN_SHIFT                0

#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_RST_PD_READY_MASK           0x02
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_RST_PD_READY_SHIFT          1

#define SERDES_25G_LANE_TOP_LN_STAT_STATUS0_RST_PD_READY_MASK            0x01
#define SERDES_25G_LANE_TOP_LN_STAT_STATUS0_RST_PD_READY_SHIFT           0

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_OVR_EN_MASK                     0x01
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_OVR_EN_SHIFT                    0

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_DATA_WIDTH_MASK              0x02
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_DATA_WIDTH_SHIFT             1

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RX_DATA_WIDTH_MASK              0x04
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RX_DATA_WIDTH_SHIFT             2

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RXPOLARITY_MASK                 0x08
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RXPOLARITY_SHIFT                3

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_EN_MASK                      0x10
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_EN_SHIFT                     4

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_EN_MASK                 0x20
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_EN_SHIFT                5

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_VALUE_MASK              0x40
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_VALUE_SHIFT             6

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_OVR_EN_MASK                     0x01
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_OVR_EN_SHIFT                    0

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_PD_MASK                         0x06
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_PD_SHIFT                        1

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_RST_N_MASK                      0x08
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_RST_N_SHIFT                     3

#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_TX_DATA_WIDTH_MASK           0x01
#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_TX_DATA_WIDTH_SHIFT          0

#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_RX_DATA_WIDTH_MASK           0x02
#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_RX_DATA_WIDTH_SHIFT          1

#define SERDES_25G_LANE_TOP_ERR_CTRL1_ERR_CODE_7_0_MASK                  0xFF
#define SERDES_25G_LANE_TOP_ERR_CTRL1_ERR_CODE_7_0_SHIFT                 0

#define SERDES_25G_LANE_TOP_ERR_CTRL2_ERR_CODE_15_8_MASK                 0xFF
#define SERDES_25G_LANE_TOP_ERR_CTRL2_ERR_CODE_15_8_SHIFT                0

/*********************************  Lane CDR RXCLK ***************************/
#define SERDES_25G_LANE_CDR_RXCLK_BASE					0x80

#define SERDES_25G_LANE_CDR_RXCLK_CAL_CTRL0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x10)
#define SERDES_25G_LANE_CDR_RXCLK_CAL_CTRL1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x11)
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x21)
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x22)
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x26)
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x27)
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL2_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x28)
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL3_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x29)
#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x2A)
#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x2B)
#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL2_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x2D)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x30)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x31)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL2_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x32)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL3_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x34)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL4_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x36)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL5_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x37)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL6_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x39)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x3A)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL8_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x3B)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x3C)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x3D)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS2_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x3E)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS3_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x3F)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS4_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x40)
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS5_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x41)
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x44)
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x45)
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS2_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x46)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x48)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x49)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL2_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x4A)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL3_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x4B)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL0_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x4C)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL1_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x4D)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL2_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x4E)
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL3_ADDR		(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x4F)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL0_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x60)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL1_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x61)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL2_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x62)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL3_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x63)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_STATUS0_ADDR (SERDES_25G_LANE_CDR_RXCLK_BASE + 0x68)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS0_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x69)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS1_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x6A)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS2_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x6B)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS0_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x6C)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS1_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x6D)
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS2_ADDR	(SERDES_25G_LANE_CDR_RXCLK_BASE + 0x6E)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_CDR_RXCLK_CAL_CTRL0_DLPF_SRC_SEL_MASK			0x01
#define SERDES_25G_LANE_CDR_RXCLK_CAL_CTRL0_DLPF_SRC_SEL_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_CAL_CTRL1_CFG_DOSC_MIN_MASK			0x07
#define SERDES_25G_LANE_CDR_RXCLK_CAL_CTRL1_CFG_DOSC_MIN_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL0_DECIMATION_MODE_MASK		0x0F
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL0_DECIMATION_MODE_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL0_DLPF_MODE_MASK			0x30
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL0_DLPF_MODE_SHIFT		4

#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL1_PD_OUT_MASK_MASK		0x03
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_CTRL1_PD_OUT_MASK_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL0_DLPF_VAL_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL0_DLPF_VAL_7_0_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL1_DLPF_VAL_8_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL1_DLPF_VAL_8_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL2_DLPF_DITHER_VAL_7_0_MASK	0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL2_DLPF_DITHER_VAL_7_0_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL3_DLPF_DITHER_VAL_10_8_MASK	0x07
#define SERDES_25G_LANE_CDR_RXCLK_LOAD_MODE_CTRL3_DLPF_DITHER_VAL_10_8_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL0_DLPF_VAL_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL0_DLPF_VAL_7_0_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL1_DLPF_VAL_8_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL1_DLPF_VAL_8_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL2_EN_MASK			0x01
#define SERDES_25G_LANE_CDR_RXCLK_FORCE_MODE_CTRL2_EN_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL0_NUM_DITHER_BITS_MASK		0x0F
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL0_NUM_DITHER_BITS_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL1_HIGH_THRESHOLD_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL1_HIGH_THRESHOLD_7_0_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL2_HIGH_THRESHOLD_8_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL2_HIGH_THRESHOLD_8_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL3_HIGH_COUNT_MASK			0x0F
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL3_HIGH_COUNT_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL4_LOW_THRESHOLD_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL4_LOW_THRESHOLD_7_0_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL5_LOW_THRESHOLD_8_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL5_LOW_THRESHOLD_8_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL6_LOW_COUNT_MASK			0x0F
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL6_LOW_COUNT_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_LOCK_EN_MASK			0x01
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_LOCK_EN_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_LOCKL_EN_MASK			0x02
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_LOCKL_EN_SHIFT			1

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_HIGH_EN_MASK			0x04
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_HIGH_EN_SHIFT			2

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_LOW_EN_MASK			0x08
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL7_LOW_EN_SHIFT			3

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL8_OUTPUT_SAMPLE_PERIOD_MASK		0x3F
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_CTRL8_OUTPUT_SAMPLE_PERIOD_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS0_GREY_VAL_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS0_GREY_VAL_7_0_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS1_GREY_VAL_8_MASK			0x01
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS1_GREY_VAL_8_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS2_BINARY_VAL_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS2_BINARY_VAL_7_0_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS3_BINARY_VAL_8_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS3_BINARY_VAL_8_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS4_DLPF_TOO_HIGH_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS4_DLPF_TOO_HIGH_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS4_DLPF_TOO_LOW_MASK		0x02
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS4_DLPF_TOO_LOW_SHIFT		1

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS4_LOCK_LOST_MASK			0x04
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS4_LOCK_LOST_SHIFT			2

#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS5_LOCKED_MASK			0x01
#define SERDES_25G_LANE_CDR_RXCLK_DLPF_STATUS5_LOCKED_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS0_ACCUMULATOR_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS0_ACCUMULATOR_7_0_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS1_ACCUMULATOR_15_8_MASK	0xFF
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS1_ACCUMULATOR_15_8_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS2_ACCUMULATOR_19_16_MASK	0x0F
#define SERDES_25G_LANE_CDR_RXCLK_INTEGRAL_STATUS2_ACCUMULATOR_19_16_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL0_DITHER_BITS_MASK			0x0F
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL0_DITHER_BITS_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL0_SAMPLE_PERIOD_MASK		0xF0
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL0_SAMPLE_PERIOD_SHIFT		4

#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL1_NUM_SAMPLES_MASK			0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL1_NUM_SAMPLES_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL2_SLOPE_THRESHOLD_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL2_SLOPE_THRESHOLD_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL3_RANGE_THRESHOLD_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOCKD_CTRL3_RANGE_THRESHOLD_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL0_DITHER_BITS_MASK			0x0F
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL0_DITHER_BITS_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL0_SAMPLE_PERIOD_MASK		0xF0
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL0_SAMPLE_PERIOD_SHIFT		4

#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL1_NUM_SAMPLES_MASK			0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL1_NUM_SAMPLES_SHIFT			0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL2_SLOPE_THRESHOLD_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL2_SLOPE_THRESHOLD_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL3_RANGE_THRESHOLD_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_LOCKL_CTRL3_RANGE_THRESHOLD_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL0_EN_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL0_EN_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL1_SAMPLE_DROP_BITS_MASK	0x07
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL1_SAMPLE_DROP_BITS_SHIFT 0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL1_NUM_PEAKS_MASK	0xF0
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL1_NUM_PEAKS_SHIFT	4

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL2_PEAK2PEAK_PERIOD_MIN_MASK	0xFF
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL2_PEAK2PEAK_PERIOD_MIN_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL3_PEAK2PEAK_PERIOD_MAX_MASK	0xFF
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_CTRL3_PEAK2PEAK_PERIOD_MAX_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_STATUS0_DONE_MASK		0x01
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_STATUS0_DONE_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_STATUS0_NOISY_MASK		0x02
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_STATUS0_NOISY_SHIFT		1

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_STATUS0_SLOW_MASK		0x04
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_PEAK_DETECT_STATUS0_SLOW_SHIFT		2

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS0_VAL_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS0_VAL_7_0_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS1_VAL_15_8_MASK	0xFF
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS1_VAL_15_8_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS2_VAL_19_16_MASK	0x0F
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_FIRST_PEAK_STATUS2_VAL_19_16_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS0_VAL_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS0_VAL_7_0_SHIFT		0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS1_VAL_15_8_MASK		0xFF
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS1_VAL_15_8_SHIFT	0

#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS2_VAL_19_16_MASK	0x0F
#define SERDES_25G_LANE_CDR_RXCLK_ACCUM_LAST_PEAK_STATUS2_VAL_19_16_SHIFT	0

/*********************************  Lane CDR_REFCLK ***************************/
#define SERDES_25G_LANE_CDR_REFCLK_BASE					0x180

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL0_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x00)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL1_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x01)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_RST_CTRL0_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x06)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL0_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x0A)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL1_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x0B)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL2_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x0C)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL0_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x10)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL1_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x11)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL0_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x18)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL1_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x19)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL2_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x1A)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL3_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x1B)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL0_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x20)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL1_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x21)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL2_ADDR	(SERDES_25G_LANE_CDR_REFCLK_BASE + 0x22)
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCOCAL_STATUS0_ADDR (SERDES_25G_LANE_CDR_REFCLK_BASE + 0x24)
#define SERDES_25G_LANE_CDR_REFCLK_RXCDR_HSCAN_EYE_CFG_ADDR (SERDES_25G_LANE_CDR_REFCLK_BASE + 0x30)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL0_PD_RXCDR_MASK				0x01
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL0_PD_RXCDR_SHIFT				0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL0_PD_RXCDR_EYE_MASK			0x02
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL0_PD_RXCDR_EYE_SHIFT			1

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL0_RXCDR_TOGGLE_EN_MASK			0x04
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL0_RXCDR_TOGGLE_EN_SHIFT			2

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL1_RXCDR_PHD_EN_MASK			0xFF
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PD_CTRL1_RXCDR_PHD_EN_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_RST_CTRL0_RST_RXCDR_PHD_N_MASK			0x01
#define SERDES_25G_LANE_CDR_REFCLK_AFE_RST_CTRL0_RST_RXCDR_PHD_N_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_RST_CTRL0_RST_RXCDR_CLKDIV_N_MASK		0x02
#define SERDES_25G_LANE_CDR_REFCLK_AFE_RST_CTRL0_RST_RXCDR_CLKDIV_N_SHIFT		1

#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL0_RXCDR_VCO_KICK_MASK			0x01
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL0_RXCDR_VCO_KICK_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL1_RXCDR_REGDAC_BANDWIDTH_MASK		0x01
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL1_RXCDR_REGDAC_BANDWIDTH_SHIFT		0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL1_RXCDR_SHORT_VOSC_PRP_MASK		0x02
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL1_RXCDR_SHORT_VOSC_PRP_SHIFT		1

#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL1_RXCDR_REFDAC_GAIN_MASK			0x0C
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL1_RXCDR_REFDAC_GAIN_SHIFT		2

#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL2_RXCDR_DOSC_MASK			0x07
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCO_CTRL2_RXCDR_DOSC_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL0_RXCDR_BBSTEP_MASK				0x1F
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL0_RXCDR_BBSTEP_SHIFT				0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL0_RXCDR_CLKDIV_MASK				0x60
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL0_RXCDR_CLKDIV_SHIFT				5

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL1_RXCDR_CLKDIV_SWING_MASK			0x03
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL1_RXCDR_CLKDIV_SWING_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL1_RXCDR_SPARE_MASK				0x3C
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CTRL1_RXCDR_SPARE_SHIFT				2

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL0_RXCDR_HSCAN_CLKQ_MASK			0x7F
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL0_RXCDR_HSCAN_CLKQ_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL0_SRC_SEL_MASK				0x80
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL0_SRC_SEL_SHIFT				7

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL1_RXCDR_HSCAN_CLKI_MASK			0x7F
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL1_RXCDR_HSCAN_CLKI_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL1_SRC_SEL_MASK				0x80
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL1_SRC_SEL_SHIFT				7

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL2_RXCDR_HSCAN_EYE_MASK			0x7F
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL2_RXCDR_HSCAN_EYE_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL3_RXCDR_PI_CAP_MASK			0x07
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL3_RXCDR_PI_CAP_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL3_RXCDR_PI_SWING_MASK			0x18
#define SERDES_25G_LANE_CDR_REFCLK_AFE_PI_CTRL3_RXCDR_PI_SWING_SHIFT			3

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL0_RXCDR_CAL_EN_MASK			0x01
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL0_RXCDR_CAL_EN_SHIFT			0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL0_RXCDR_VCOCAL_DIV4_MASK			0x02
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL0_RXCDR_VCOCAL_DIV4_SHIFT		1

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL1_RXCDR_VCOCAL_LOAD_VAL_11_8_MASK	0x0F
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL1_RXCDR_VCOCAL_LOAD_VAL_11_8_SHIFT	0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL2_RXCDR_VCOCAL_LOAD_VAL_7_0_MASK		0xFF
#define SERDES_25G_LANE_CDR_REFCLK_AFE_CAL_CTRL2_RXCDR_VCOCAL_LOAD_VAL_7_0_SHIFT	 0

#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCOCAL_STATUS0_RXCDR_VCOCAL_UP_MASK		0x01
#define SERDES_25G_LANE_CDR_REFCLK_AFE_VCOCAL_STATUS0_RXCDR_VCOCAL_UP_SHIFT		0

#define SERDES_25G_LANE_CDR_REFCLK_RXCDR_HSCAN_EYE_CFG_ZERO_PHASE_MASK			0x7F
#define SERDES_25G_LANE_CDR_REFCLK_RXCDR_HSCAN_EYE_CFG_ZERO_PHASE_SHIFT			0

/*********************************  Lane BIST *********************************/
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_ADDR			0x00
#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_ADDR				0x01
#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_ADDR				0x02
#define SERDES_25G_LANE_TOP_AFE_BIAS_PD_CTRL_ADDR			0x03
#define SERDES_25G_LANE_TOP_AFE_RX_RST_CTRL_ADDR			0x04
#define SERDES_25G_LANE_TOP_AFE_TX_RST_CTRL_ADDR			0x05
#define SERDES_25G_LANE_TOP_AFE_BIAS_CTRL_ADDR				0x06
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_ADDR				0x10
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_ADDR				0x12
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL3_ADDR				0x13
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_ADDR				0x14
#define SERDES_25G_LANE_TOP_AFE_TXDP_CTRL0_ADDR				0x16
#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_ADDR				0x19
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_ADDR			0x1B
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL1_ADDR			0x1C
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_ADDR				0x22
#define SERDES_25G_LANE_TOP_DPL_RXDP_CTRL1_ADDR				0x24
#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_ADDR			0x25
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_ADDR			0x26
#define SERDES_25G_LANE_TOP_PHY_IF_STATUS_ADDR				0x27
#define SERDES_25G_LANE_TOP_DELAY_CTRL0_ADDR				0x30
#define SERDES_25G_LANE_TOP_DELAY_CTRL1_ADDR				0x31
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL0_ADDR				0x38
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_ADDR			0x39
#define SERDES_25G_LANE_TOP_LN_STAT_STATUS0_ADDR			0x3A
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_ADDR				0x3B
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_ADDR				0x3C
#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_ADDR			0x3D
#define SERDES_25G_LANE_TOP_ERR_CTRL1_ADDR				0x40
#define SERDES_25G_LANE_TOP_ERR_CTRL2_ADDR				0x41
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_RXCLK_EN_MASK	0x01
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_RXCLK_EN_SHIFT	0

#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_TXCLK_EN_MASK	0x02
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_TXCLK_EN_SHIFT	1

#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_FEA_EN_MASK	0x04
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_FEA_EN_SHIFT	2

#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_NEA_EN_MASK	0x08
#define SERDES_25G_LANE_TOP_AFE_LOOPBACK_CTRL_LOOPBACK_NEA_EN_SHIFT	3

#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXTERM_MASK		0x01
#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXTERM_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXDP_MASK			0x02
#define SERDES_25G_LANE_TOP_AFE_RX_PD_CTRL_PD_RXDP_SHIFT		1

#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_REG_TXCP_MASK		0x01
#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_REG_TXCP_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_TXCP_MASK			0x02
#define SERDES_25G_LANE_TOP_AFE_TX_PD_CTRL_PD_TXCP_SHIFT		1

#define SERDES_25G_LANE_TOP_AFE_BIAS_PD_CTRL_PD_BIAS_LANE_MASK		0x01
#define SERDES_25G_LANE_TOP_AFE_BIAS_PD_CTRL_PD_BIAS_LANE_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_RX_RST_CTRL_RST_RXDP_N_MASK		0x01
#define SERDES_25G_LANE_TOP_AFE_RX_RST_CTRL_RST_RXDP_N_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_TX_RST_CTRL_RST_TXDP_N_MASK		0x04
#define SERDES_25G_LANE_TOP_AFE_TX_RST_CTRL_RST_TXDP_N_SHIFT		2

#define SERDES_25G_LANE_TOP_AFE_BIAS_CTRL_BIAS_SPARE_MASK		0x0F
#define SERDES_25G_LANE_TOP_AFE_BIAS_CTRL_BIAS_SPARE_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRIM_MASK		0x0F
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRIM_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRICKLE_MASK	0x30
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_TRICKLE_SHIFT	4

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_PASS_EN_MASK	0x40
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL0_REG_TXCP_PASS_EN_SHIFT	6

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_TSTCLK_EN_MASK		0x01
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_TSTCLK_EN_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_CLKDIV_MASK		0x06
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL2_TXCP_CLKDIV_SHIFT		1

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL3_TXCP_SPARE_MASK		0x0F
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL3_TXCP_SPARE_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_CLKDIV_SWING_MASK	0x03
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_CLKDIV_SWING_SHIFT	0

#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_TOGGLE_EN_MASK		0x04
#define SERDES_25G_LANE_TOP_AFE_TXCP_CTRL4_TXCP_TOGGLE_EN_SHIFT		2

#define SERDES_25G_LANE_TOP_AFE_TXDP_CTRL0_TXDP_SPARE_MASK		0xF0
#define SERDES_25G_LANE_TOP_AFE_TXDP_CTRL0_TXDP_SPARE_SHIFT		4

#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_CLKDLY_MASK		0x07
#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_CLKDLY_SHIFT		0

#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_SPARE_MASK		0xF0
#define SERDES_25G_LANE_TOP_AFE_RXDP_CTRL0_RXDP_SPARE_SHIFT		4

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_CMFILT_MASK		0x07
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_CMFILT_SHIFT	0

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_HIZ_MASK		0x08
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_HIZ_SHIFT		3

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_VCM_GND_MASK	0x10
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL0_RXTERM_VCM_GND_SHIFT	4

#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL1_RXTERM_VAL_MASK		0x1F
#define SERDES_25G_LANE_TOP_AFE_RXTERM_CTRL1_RXTERM_VAL_SHIFT		0

#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_SEL_MASK		0x03
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_SEL_SHIFT		0

#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_TXPOLARITY_MASK		0x04
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_TXPOLARITY_SHIFT		2

#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_LB_FED_TX_EN_MASK	0x10
#define SERDES_25G_LANE_TOP_DPL_TXDP_CTRL1_DMUX_TXA_LB_FED_TX_EN_SHIFT	4

#define SERDES_25G_LANE_TOP_DPL_RXDP_CTRL1_DMUX_RX_SEL_MASK		0x01
#define SERDES_25G_LANE_TOP_DPL_RXDP_CTRL1_DMUX_RX_SEL_SHIFT		0

#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_STATE_MASK		0x07
#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_STATE_SHIFT		0

#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_REQ_MASK		0x08
#define SERDES_25G_LANE_TOP_PWR_STATE_REQ_STATUS_REQ_SHIFT		3

#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_STATE_MASK		0x07
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_STATE_SHIFT		0

#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_ACK_MASK			0x08
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_ACK_SHIFT		3

#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_DELAY_LEN_MASK		0x70
#define SERDES_25G_LANE_TOP_PWR_STATE_ACK_CTRL_DELAY_LEN_SHIFT		4

#define SERDES_25G_LANE_TOP_PHY_IF_STATUS_LN_OK_MASK			0x01
#define SERDES_25G_LANE_TOP_PHY_IF_STATUS_LN_OK_SHIFT			0

#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_DATA_EDELAY_MASK		0x07
#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_DATA_EDELAY_SHIFT		0

#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_EDGE_DELAY_MASK		0x38
#define SERDES_25G_LANE_TOP_DELAY_CTRL0_RX_EDGE_DELAY_SHIFT		3

#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_DATA_IDELAY_MASK		0x07
#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_DATA_IDELAY_SHIFT		0

#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_EYE_DELAY_MASK		0x38
#define SERDES_25G_LANE_TOP_DELAY_CTRL1_RX_EYE_DELAY_SHIFT		3

#define SERDES_25G_LANE_TOP_LN_STAT_CTRL0_RXVALID_MASK			0x01
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL0_RXVALID_SHIFT			0

#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_OVR_EN_MASK		0x01
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_OVR_EN_SHIFT		0

#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_RST_PD_READY_MASK		0x02
#define SERDES_25G_LANE_TOP_LN_STAT_CTRL_OVR_RST_PD_READY_SHIFT		1

#define SERDES_25G_LANE_TOP_LN_STAT_STATUS0_RST_PD_READY_MASK		0x01
#define SERDES_25G_LANE_TOP_LN_STAT_STATUS0_RST_PD_READY_SHIFT		0

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_OVR_EN_MASK			0x01
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_OVR_EN_SHIFT			0

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_DATA_WIDTH_MASK		0x02
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_DATA_WIDTH_SHIFT		1

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RX_DATA_WIDTH_MASK		0x04
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RX_DATA_WIDTH_SHIFT		2

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RXPOLARITY_MASK		0x08
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_RXPOLARITY_SHIFT		3

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_EN_MASK			0x10
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_TX_EN_SHIFT			4

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_EN_MASK		0x20
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_EN_SHIFT		5

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_VALUE_MASK		0x40
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR0_LOS_EII_VALUE_SHIFT		6

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_OVR_EN_MASK			0x01
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_OVR_EN_SHIFT			0

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_PD_MASK			0x06
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_PD_SHIFT			1

#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_RST_N_MASK			0x08
#define SERDES_25G_LANE_TOP_LN_CTRL_OVR1_RST_N_SHIFT			3

#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_TX_DATA_WIDTH_MASK		0x01
#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_TX_DATA_WIDTH_SHIFT		0

#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_RX_DATA_WIDTH_MASK		0x02
#define SERDES_25G_LANE_TOP_LN_CTRL_STATUS0_RX_DATA_WIDTH_SHIFT		1

#define SERDES_25G_LANE_TOP_ERR_CTRL1_ERR_CODE_7_0_MASK			0xFF
#define SERDES_25G_LANE_TOP_ERR_CTRL1_ERR_CODE_7_0_SHIFT		0

#define SERDES_25G_LANE_TOP_ERR_CTRL2_ERR_CODE_15_8_MASK		0xFF
#define SERDES_25G_LANE_TOP_ERR_CTRL2_ERR_CODE_15_8_SHIFT		0

/********************************* LEQ_REFCLK *********************************/
#define SERDES_25G_LANE_LEQ_REFCLK_BASE					0x200

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PD_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x00)
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x02)
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x03)
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PLE_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x05)
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_EQ_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x07)
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_MISC_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x09)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x0A)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x0B)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x0C)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x0E)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x0F)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x10)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x11)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x20)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x21)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x22)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x23)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x24)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x25)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x26)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x27)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS4_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x28)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x29)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x2A)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS5_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x2B)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS6_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x2C)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_OUTINTF_CTRL0_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x2E)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x30)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x31)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x32)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x33)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL4_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x34)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL5_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x35)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL6_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x36)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL7_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x37)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL8_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x38)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL9_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x39)
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL10_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x3A)
#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x3D)
#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x3E)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL0_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x40)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL1_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x41)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL2_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x42)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL3_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x43)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL4_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x44)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL5_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x45)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL6_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x46)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x50)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x51)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x52)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x53)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL4_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x54)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL5_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x55)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL6_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x56)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL7_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x57)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL8_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x58)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL9_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x59)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL10_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x5A)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL11_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x5B)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL12_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x5C)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL13_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x5D)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL14_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x5E)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL15_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x5F)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL16_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x60)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL17_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x61)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL18_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x62)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL19_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x63)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL20_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x64)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL21_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x65)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL22_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x66)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL23_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x67)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL24_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x68)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x70)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x71)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x72)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x73)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL4_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x74)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL5_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x75)
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL6_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x76)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x80)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x81)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x82)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x83)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL4_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x84)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL5_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x85)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL6_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x86)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL7_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x87)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL8_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x88)
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL0_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x90)
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL1_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x91)
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL2_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x92)
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL3_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x93)
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL4_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x94)
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL5_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x95)
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL6_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x96)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x98)
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x99)
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x9A)
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x9B)
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x9C)
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0x9D)
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA0)
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA1)
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA2)
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA3)
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA6)
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA7)
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD2_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA8)
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD3_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xA9)
#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xAB)
#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE1_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xAC)
#define SERDES_25G_LANE_LEQ_REFCLK_EYEMON_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xAE)
#define SERDES_25G_LANE_LEQ_REFCLK_EYEINTF_CTRL0_ADDR	(SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xAF)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_REFCLK_SPARE0_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xB8)
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_REFCLK_SPARE1_ADDR (SERDES_25G_LANE_LEQ_REFCLK_BASE + 0xB9)

/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PD_CTRL0_PD_RXLEQ_MASK			 0x3F
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PD_CTRL0_PD_RXLEQ_SHIFT			 0

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PD_CTRL0_PD_RXLEQ_BIASGEN_MASK		 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PD_CTRL0_PD_RXLEQ_BIASGEN_SHIFT		 6

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL0_RXLEQ_BIAS_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL0_RXLEQ_BIAS_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL1_RXLEQ_VGSW_SEL_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL1_RXLEQ_VGSW_SEL_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL1_RXLEQ_BIASI_TRIM_MASK		 0x18
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_BIAS_CTRL1_RXLEQ_BIASI_TRIM_SHIFT	 3

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PLE_CTRL0_RXLEQ_PLE_MUTE_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PLE_CTRL0_RXLEQ_PLE_MUTE_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PLE_CTRL0_RXLEQ_PLE_BLW_ZERO_MASK	 0x06
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PLE_CTRL0_RXLEQ_PLE_BLW_ZERO_SHIFT	 1

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PLE_CTRL0_RXLEQ_PLE_PRECH_MASK		 0x08
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_PLE_CTRL0_RXLEQ_PLE_PRECH_SHIFT		 3

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_EQ_CTRL0_RXLEQ_EQ_SQL_DIR_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_EQ_CTRL0_RXLEQ_EQ_SQL_DIR_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AFE_MISC_CTRL0_RXLEQ_SPARE_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_AFE_MISC_CTRL0_RXLEQ_SPARE_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL0_GN_LOADRES_START0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL0_GN_LOADRES_START0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL0_GN_LOADRES_START1_MASK		 0x38
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL0_GN_LOADRES_START1_SHIFT		 3

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL1_GN_LOADRES_START2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL1_GN_LOADRES_START2_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL1_GN_LOADRES_START3_MASK		 0x38
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL1_GN_LOADRES_START3_SHIFT		 3

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE0_MASK			 0x03
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE1_MASK			 0x0C
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE1_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE2_MASK			 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE2_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE3_MASK			 0xC0
#define SERDES_25G_LANE_LEQ_REFCLK_GN_CTRL2_GN_BIASI_RATE3_SHIFT		 6

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL0_EQ_LOADRES_START0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL0_EQ_LOADRES_START0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL0_EQ_LOADRES_START1_MASK		 0x38
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL0_EQ_LOADRES_START1_SHIFT		 3

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL1_EQ_LOADRES_START2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL1_EQ_LOADRES_START2_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL1_EQ_LOADRES_START3_MASK		 0x38
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL1_EQ_LOADRES_START3_SHIFT		 3

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL2_EQ_BIASRES_START0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL2_EQ_BIASRES_START0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL2_EQ_BIASRES_START1_MASK		 0x38
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL2_EQ_BIASRES_START1_SHIFT		 3

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL3_EQ_BIASRES_START2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL3_EQ_BIASRES_START2_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL3_EQ_BIASRES_START3_MASK		 0x38
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_CTRL3_EQ_BIASRES_START3_SHIFT		 3

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL0_LEQ_FSM_CMD_REQ_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL0_LEQ_FSM_CMD_REQ_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL0_LEQ_FSM_STATE_RESET_MASK	 0x04
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL0_LEQ_FSM_STATE_RESET_SHIFT	 2

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD0_LEQ_FSM_CMD_OPCODE_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD0_LEQ_FSM_CMD_OPCODE_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD0_LEQ_FSM_CMD_TARGET_MASK		 0xF0
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD0_LEQ_FSM_CMD_TARGET_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD1_LEQ_FSM_CMD_SCRATCHPAD_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD1_LEQ_FSM_CMD_SCRATCHPAD_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD2_LEQ_FSM_CMD_MISC_OPTION_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CMD2_LEQ_FSM_CMD_MISC_OPTION_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_STATUS_ERROR1_MASK	 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_STATUS_ERROR1_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_STATUS_ERROR2_MASK	 0x38
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_STATUS_ERROR2_SHIFT	 3

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_MAX_CLAMP_MASK	 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_MAX_CLAMP_SHIFT	 6

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_MIN_CLAMP_MASK	 0x80
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS0_LEQ_FSM_MIN_CLAMP_SHIFT	 7

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS1_LEQ_FSM_STATE_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS1_LEQ_FSM_STATE_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS1_LEQ_FSM_LAST_RESULT_MASK	 0xF0
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS1_LEQ_FSM_LAST_RESULT_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS2_LEQ_FSM_LAST_STEP_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS2_LEQ_FSM_LAST_STEP_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS3_LEQ_FSM_LAST_VALUE_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS3_LEQ_FSM_LAST_VALUE_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS4_LEQ_FSM_LAST_OPCODE_MASK	 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS4_LEQ_FSM_LAST_OPCODE_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS4_LEQ_FSM_LAST_TARGET_MASK	 0xF0
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS4_LEQ_FSM_LAST_TARGET_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL1_LEQ_FSM_TIMEOUT_LIMIT_7_0_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL1_LEQ_FSM_TIMEOUT_LIMIT_7_0_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL2_LEQ_FSM_TIMEOUT_LIMIT_15_8_MASK 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_CTRL2_LEQ_FSM_TIMEOUT_LIMIT_15_8_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS5_LEQ_FSM_CMD_ACK_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS5_LEQ_FSM_CMD_ACK_SHIFT	 1

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS6_LEQ_FSM_2LST_VALUE_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_FSM_STATUS6_LEQ_FSM_2LST_VALUE_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_OUTINTF_CTRL0_LEQ_OUTINTF_RDY_WAIT_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_OUTINTF_CTRL0_LEQ_OUTINTF_RDY_WAIT_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL0_AGCLOS_START_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL0_AGCLOS_START_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL1_AGCLOS_VALUE_MAX_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL1_AGCLOS_VALUE_MAX_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL2_AGCLOS_VALUE_MIN_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL2_AGCLOS_VALUE_MIN_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL3_AGCLOS_WRWAIT_TIME_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL3_AGCLOS_WRWAIT_TIME_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL3_AGCLOS_INIT_TIMEOUT_DISABLE_MASK 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL3_AGCLOS_INIT_TIMEOUT_DISABLE_SHIFT 6

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL3_AGCLOS_MEASURE_TIMEOUT_DISABLE_MASK 0x80
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL3_AGCLOS_MEASURE_TIMEOUT_DISABLE_SHIFT 7

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL4_AGCLOS_STEP_BY1_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL4_AGCLOS_STEP_BY1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL4_AGCLOS_ERROR_SIGN_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL4_AGCLOS_ERROR_SIGN_SHIFT		 1

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL4_AGCLOS_STEP_SIZE_MASK		 0x1C
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL4_AGCLOS_STEP_SIZE_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL5_AGCLOS_BOUNCE_LIMIT_MASK	 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL5_AGCLOS_BOUNCE_LIMIT_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL5_AGCLOS_LASTWR_AVG_MASK		 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL5_AGCLOS_LASTWR_AVG_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL5_AGCLOS_LASTWR_FLOOR_MASK	 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL5_AGCLOS_LASTWR_FLOOR_SHIFT	 6

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL6_AGCLOS_LASTWR_ADJUST_MASK	 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL6_AGCLOS_LASTWR_ADJUST_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL7_AGCLOS_PEAK_ACQ_TIME_7_0_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL7_AGCLOS_PEAK_ACQ_TIME_7_0_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL8_AGCLOS_PEAK_ACQ_TIME_15_8_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL8_AGCLOS_PEAK_ACQ_TIME_15_8_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL9_AGCLOS_PEAK_ACQ_TIME_23_16_MASK	 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL9_AGCLOS_PEAK_ACQ_TIME_23_16_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL10_AGCLOS_PEAK_ACQ_TIME_25_24_MASK 0x03
#define SERDES_25G_LANE_LEQ_REFCLK_AGCLOS_CTRL10_AGCLOS_PEAK_ACQ_TIME_25_24_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL0_PLE_LFG_WRWAIT_TIME_MASK	 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL0_PLE_LFG_WRWAIT_TIME_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL0_PLE_LFG_STEP_BY1_MASK		 0x10
#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL0_PLE_LFG_STEP_BY1_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL1_PLE_LFG_START_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_PLE_LFG_CTRL1_PLE_LFG_START_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL0_EQ_HFG_SQL_START_MASK	 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL0_EQ_HFG_SQL_START_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL1_EQ_HFG_SQL_VALUE_MAX_MASK	 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL1_EQ_HFG_SQL_VALUE_MAX_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL2_EQ_HFG_SQL_VALUE_MIN_MASK	 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL2_EQ_HFG_SQL_VALUE_MIN_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL3_EQ_HFG_SQL_WRWAIT_TIME_MASK	 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL3_EQ_HFG_SQL_WRWAIT_TIME_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL3_EQ_HFG_SQL_MEASURE_TIMEOUT_DISABLE_MASK 0x80
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL3_EQ_HFG_SQL_MEASURE_TIMEOUT_DISABLE_SHIFT 7

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL4_EQ_HFG_SQL_STEP_BY1_MASK	 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL4_EQ_HFG_SQL_STEP_BY1_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL4_EQ_HFG_SQL_ERROR_SIGN_MASK	 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL4_EQ_HFG_SQL_ERROR_SIGN_SHIFT	 1

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL4_EQ_HFG_SQL_STEP_SIZE_MASK	 0x1C
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL4_EQ_HFG_SQL_STEP_SIZE_SHIFT	 2

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL5_EQ_HFG_SQL_BOUNCE_LIMIT_MASK 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL5_EQ_HFG_SQL_BOUNCE_LIMIT_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL5_EQ_HFG_SQL_LASTWR_AVG_MASK	 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL5_EQ_HFG_SQL_LASTWR_AVG_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL5_EQ_HFG_SQL_LASTWR_FLOOR_MASK 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL5_EQ_HFG_SQL_LASTWR_FLOOR_SHIFT 6

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL6_EQ_HFG_SQL_LASTWR_ADJUST_MASK 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_HFG_SQL_CTRL6_EQ_HFG_SQL_LASTWR_ADJUST_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE0_MASK	 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE0_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE1_MASK	 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE1_SHIFT	 1

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE2_MASK	 0x04
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE2_SHIFT	 2

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE3_MASK	 0x08
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL0_EQ_SQL_MAP_OPTION_RATE3_SHIFT	 3

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL1_EQ_SQL_MAP0_RATE0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL1_EQ_SQL_MAP0_RATE0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL1_EQ_SQL_MAP1_RATE0_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL1_EQ_SQL_MAP1_RATE0_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL2_EQ_SQL_MAP2_RATE0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL2_EQ_SQL_MAP2_RATE0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL2_EQ_SQL_MAP3_RATE0_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL2_EQ_SQL_MAP3_RATE0_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL3_EQ_SQL_MAP4_RATE0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL3_EQ_SQL_MAP4_RATE0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL3_EQ_SQL_MAP5_RATE0_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL3_EQ_SQL_MAP5_RATE0_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL4_EQ_SQL_MAP6_RATE0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL4_EQ_SQL_MAP6_RATE0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL4_EQ_SQL_MAP7_RATE0_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL4_EQ_SQL_MAP7_RATE0_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL5_EQ_SQL_MAP8_RATE0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL5_EQ_SQL_MAP8_RATE0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL5_EQ_SQL_MAP9_RATE0_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL5_EQ_SQL_MAP9_RATE0_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL6_EQ_SQL_MAP10_RATE0_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL6_EQ_SQL_MAP10_RATE0_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL6_EQ_SQL_MAP11_RATE0_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL6_EQ_SQL_MAP11_RATE0_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL7_EQ_SQL_MAP0_RATE1_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL7_EQ_SQL_MAP0_RATE1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL7_EQ_SQL_MAP1_RATE1_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL7_EQ_SQL_MAP1_RATE1_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL8_EQ_SQL_MAP2_RATE1_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL8_EQ_SQL_MAP2_RATE1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL8_EQ_SQL_MAP3_RATE1_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL8_EQ_SQL_MAP3_RATE1_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL9_EQ_SQL_MAP4_RATE1_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL9_EQ_SQL_MAP4_RATE1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL9_EQ_SQL_MAP5_RATE1_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL9_EQ_SQL_MAP5_RATE1_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL10_EQ_SQL_MAP6_RATE1_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL10_EQ_SQL_MAP6_RATE1_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL10_EQ_SQL_MAP7_RATE1_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL10_EQ_SQL_MAP7_RATE1_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL11_EQ_SQL_MAP8_RATE1_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL11_EQ_SQL_MAP8_RATE1_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL11_EQ_SQL_MAP9_RATE1_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL11_EQ_SQL_MAP9_RATE1_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL12_EQ_SQL_MAP10_RATE1_MASK	 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL12_EQ_SQL_MAP10_RATE1_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL12_EQ_SQL_MAP11_RATE1_MASK	 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL12_EQ_SQL_MAP11_RATE1_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL13_EQ_SQL_MAP0_RATE2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL13_EQ_SQL_MAP0_RATE2_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL13_EQ_SQL_MAP1_RATE2_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL13_EQ_SQL_MAP1_RATE2_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL14_EQ_SQL_MAP2_RATE2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL14_EQ_SQL_MAP2_RATE2_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL14_EQ_SQL_MAP3_RATE2_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL14_EQ_SQL_MAP3_RATE2_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL15_EQ_SQL_MAP4_RATE2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL15_EQ_SQL_MAP4_RATE2_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL15_EQ_SQL_MAP5_RATE2_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL15_EQ_SQL_MAP5_RATE2_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL16_EQ_SQL_MAP6_RATE2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL16_EQ_SQL_MAP6_RATE2_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL16_EQ_SQL_MAP7_RATE2_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL16_EQ_SQL_MAP7_RATE2_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL17_EQ_SQL_MAP8_RATE2_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL17_EQ_SQL_MAP8_RATE2_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL17_EQ_SQL_MAP9_RATE2_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL17_EQ_SQL_MAP9_RATE2_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL18_EQ_SQL_MAP10_RATE2_MASK	 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL18_EQ_SQL_MAP10_RATE2_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL18_EQ_SQL_MAP11_RATE2_MASK	 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL18_EQ_SQL_MAP11_RATE2_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL19_EQ_SQL_MAP0_RATE3_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL19_EQ_SQL_MAP0_RATE3_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL19_EQ_SQL_MAP1_RATE3_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL19_EQ_SQL_MAP1_RATE3_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL20_EQ_SQL_MAP2_RATE3_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL20_EQ_SQL_MAP2_RATE3_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL20_EQ_SQL_MAP3_RATE3_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL20_EQ_SQL_MAP3_RATE3_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL21_EQ_SQL_MAP4_RATE3_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL21_EQ_SQL_MAP4_RATE3_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL21_EQ_SQL_MAP5_RATE3_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL21_EQ_SQL_MAP5_RATE3_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL22_EQ_SQL_MAP6_RATE3_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL22_EQ_SQL_MAP6_RATE3_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL22_EQ_SQL_MAP7_RATE3_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL22_EQ_SQL_MAP7_RATE3_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL23_EQ_SQL_MAP8_RATE3_MASK		 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL23_EQ_SQL_MAP8_RATE3_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL23_EQ_SQL_MAP9_RATE3_MASK		 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL23_EQ_SQL_MAP9_RATE3_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL24_EQ_SQL_MAP10_RATE3_MASK	 0x07
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL24_EQ_SQL_MAP10_RATE3_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL24_EQ_SQL_MAP11_RATE3_MASK	 0x70
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_SQL_CTRL24_EQ_SQL_MAP11_RATE3_SHIFT	 4

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL0_GN_APG_START_MASK		 0x03
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL0_GN_APG_START_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL1_GN_APG_VALUE_MAX_MASK		 0x03
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL1_GN_APG_VALUE_MAX_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL1_GN_APG_VALUE_MIN_MASK		 0x0C
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL1_GN_APG_VALUE_MIN_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL2_GN_APG_WRWAIT_TIME_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL2_GN_APG_WRWAIT_TIME_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL2_GN_APG_MEASURE_TIMEOUT_DISABLE_MASK 0x80
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL2_GN_APG_MEASURE_TIMEOUT_DISABLE_SHIFT 7

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL3_GN_APG_STEP_BY1_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL3_GN_APG_STEP_BY1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL3_GN_APG_ERROR_SIGN_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL3_GN_APG_ERROR_SIGN_SHIFT		 1

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL3_GN_APG_STEP_SIZE_MASK		 0x0C
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL3_GN_APG_STEP_SIZE_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL4_GN_APG_BOUNCE_LIMIT_MASK	 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL4_GN_APG_BOUNCE_LIMIT_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL4_GN_APG_LASTWR_AVG_MASK		 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL4_GN_APG_LASTWR_AVG_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL4_GN_APG_LASTWR_FLOOR_MASK	 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL4_GN_APG_LASTWR_FLOOR_SHIFT	 6

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL5_GN_APG_LASTWR_ADJUST_MASK	 0x03
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL5_GN_APG_LASTWR_ADJUST_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL6_GN_APG_CCL_DELTA_MASK		 0x03
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL6_GN_APG_CCL_DELTA_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL6_GN_APG_CCL_MAX_MASK		 0x0C
#define SERDES_25G_LANE_LEQ_REFCLK_GN_APG_CTRL6_GN_APG_CCL_MAX_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL0_EQ_LFG_START_MASK		 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL0_EQ_LFG_START_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL1_EQ_LFG_VALUE_MAX_MASK		 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL1_EQ_LFG_VALUE_MAX_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL2_EQ_LFG_VALUE_MIN_MASK		 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL2_EQ_LFG_VALUE_MIN_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL3_EQ_LFG_WRWAIT_TIME_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL3_EQ_LFG_WRWAIT_TIME_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL3_EQ_LFG_MEASURE_TIMEOUT_DISABLE_MASK 0x80
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL3_EQ_LFG_MEASURE_TIMEOUT_DISABLE_SHIFT 7

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL4_EQ_LFG_STEP_BY1_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL4_EQ_LFG_STEP_BY1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL4_EQ_LFG_ERROR_SIGN_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL4_EQ_LFG_ERROR_SIGN_SHIFT		 1

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL4_EQ_LFG_STEP_SIZE_MASK		 0x1C
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL4_EQ_LFG_STEP_SIZE_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL5_EQ_LFG_BOUNCE_LIMIT_MASK	 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL5_EQ_LFG_BOUNCE_LIMIT_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL5_EQ_LFG_LASTWR_AVG_MASK		 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL5_EQ_LFG_LASTWR_AVG_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL5_EQ_LFG_LASTWR_FLOOR_MASK	 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL5_EQ_LFG_LASTWR_FLOOR_SHIFT	 6

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL6_EQ_LFG_LASTWR_ADJUST_MASK	 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL6_EQ_LFG_LASTWR_ADJUST_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL7_EQ_LFG_CCL_DELTA_MASK		 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL7_EQ_LFG_CCL_DELTA_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL8_EQ_LFG_CCL_MAX_MASK		 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_LFG_CTRL8_EQ_LFG_CCL_MAX_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL0_GNEQ_CCL_LFG_START_MASK	 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL0_GNEQ_CCL_LFG_START_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL1_GNEQ_CCL_LFG_VALUE_MAX_MASK 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL1_GNEQ_CCL_LFG_VALUE_MAX_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL2_GNEQ_CCL_LFG_VALUE_MIN_MASK 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL2_GNEQ_CCL_LFG_VALUE_MIN_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL3_GNEQ_CCL_LFG_WRWAIT_TIME_MASK 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL3_GNEQ_CCL_LFG_WRWAIT_TIME_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL3_GNEQ_CCL_LFG_MEASURE_TIMEOUT_DISABLE_MASK	0x80
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL3_GNEQ_CCL_LFG_MEASURE_TIMEOUT_DISABLE_SHIFT 7

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL4_GNEQ_CCL_LFG_STEP_BY1_MASK 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL4_GNEQ_CCL_LFG_STEP_BY1_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL4_GNEQ_CCL_LFG_ERROR_SIGN_MASK 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL4_GNEQ_CCL_LFG_ERROR_SIGN_SHIFT 1

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL4_GNEQ_CCL_LFG_STEP_SIZE_MASK 0x1C
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL4_GNEQ_CCL_LFG_STEP_SIZE_SHIFT 2

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL5_GNEQ_CCL_LFG_BOUNCE_LIMIT_MASK 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL5_GNEQ_CCL_LFG_BOUNCE_LIMIT_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL5_GNEQ_CCL_LFG_LASTWR_AVG_MASK 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL5_GNEQ_CCL_LFG_LASTWR_AVG_SHIFT 4

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL5_GNEQ_CCL_LFG_LASTWR_FLOOR_MASK 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL5_GNEQ_CCL_LFG_LASTWR_FLOOR_SHIFT 6

#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL6_GNEQ_CCL_LFG_LASTWR_ADJUST_MASK 0x1F
#define SERDES_25G_LANE_LEQ_REFCLK_GNEQ_CCL_LFG_CTRL6_GNEQ_CCL_LFG_LASTWR_ADJUST_SHIFT 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL0_EQ_MB_WRWAIT_TIME_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL0_EQ_MB_WRWAIT_TIME_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL0_EQ_MB_STEP_BY1_MASK		 0x10
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL0_EQ_MB_STEP_BY1_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL1_EQ_MBF_START_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL1_EQ_MBF_START_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL1_EQ_MBG_START_MASK		 0xF0
#define SERDES_25G_LANE_LEQ_REFCLK_EQ_MB_CTRL1_EQ_MBG_START_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL0_VSCAN_VALUE_MAX_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL0_VSCAN_VALUE_MAX_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL1_VSCAN_VALUE_MIN_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL1_VSCAN_VALUE_MIN_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL2_VSCAN_STEP_BY1_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL2_VSCAN_STEP_BY1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL2_VSCAN_ERROR_SIGN_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL2_VSCAN_ERROR_SIGN_SHIFT		 1

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL2_VSCAN_STEP_SIZE_MASK		 0x3C
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL2_VSCAN_STEP_SIZE_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL3_VSCAN_BOUNCE_LIMIT_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL3_VSCAN_BOUNCE_LIMIT_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL3_VSCAN_LASTWR_AVG_MASK		 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL3_VSCAN_LASTWR_AVG_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL3_VSCAN_LASTWR_FLOOR_MASK		 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_VSCAN_CTRL3_VSCAN_LASTWR_FLOOR_SHIFT		 6

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL0_HSCAN_VALUE_MAX_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL0_HSCAN_VALUE_MAX_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL1_HSCAN_VALUE_MIN_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL1_HSCAN_VALUE_MIN_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL2_HSCAN_STEP_BY1_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL2_HSCAN_STEP_BY1_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL2_HSCAN_ERROR_SIGN_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL2_HSCAN_ERROR_SIGN_SHIFT		 1

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL2_HSCAN_STEP_SIZE_MASK		 0x3C
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL2_HSCAN_STEP_SIZE_SHIFT		 2

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL3_HSCAN_BOUNCE_LIMIT_MASK		 0x0F
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL3_HSCAN_BOUNCE_LIMIT_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL3_HSCAN_LASTWR_AVG_MASK		 0x30
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL3_HSCAN_LASTWR_AVG_SHIFT		 4

#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL3_HSCAN_LASTWR_FLOOR_MASK		 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_HSCAN_CTRL3_HSCAN_LASTWR_FLOOR_SHIFT		 6

#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD0_GN_APG_REF_N_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD0_GN_APG_REF_N_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD1_GN_APG_REF_P_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD1_GN_APG_REF_P_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD2_EQ_LFG_REF_N_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD2_EQ_LFG_REF_N_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD3_EQ_LFG_REF_P_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_REF_THRESHOLD3_EQ_LFG_REF_P_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE0_EYE_PHASE_7_0_MASK		 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE0_EYE_PHASE_7_0_SHIFT		 0

#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE1_EYE_PHASE_8_MASK			 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE1_EYE_PHASE_8_SHIFT			 0

#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE1_EYE_PHASE_VALID_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_EYE_PHASE1_EYE_PHASE_VALID_SHIFT		 1

#define SERDES_25G_LANE_LEQ_REFCLK_EYEMON_CTRL0_EYE_MONITOR_ODDEYE_MASK		 0x01
#define SERDES_25G_LANE_LEQ_REFCLK_EYEMON_CTRL0_EYE_MONITOR_ODDEYE_SHIFT	 0

#define SERDES_25G_LANE_LEQ_REFCLK_EYEMON_CTRL0_EYE_MONITOR_PATH1_MASK		 0x02
#define SERDES_25G_LANE_LEQ_REFCLK_EYEMON_CTRL0_EYE_MONITOR_PATH1_SHIFT		 1

#define SERDES_25G_LANE_LEQ_REFCLK_EYEINTF_CTRL0_EYEINTF_INIT_TIMEOUT_DISABLE_MASK 0x40
#define SERDES_25G_LANE_LEQ_REFCLK_EYEINTF_CTRL0_EYEINTF_INIT_TIMEOUT_DISABLE_SHIFT 6

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_REFCLK_SPARE0_MASK			 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_REFCLK_SPARE0_SHIFT			 0

#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_REFCLK_SPARE1_MASK			 0xFF
#define SERDES_25G_LANE_LEQ_REFCLK_LEQ_REFCLK_SPARE1_SHIFT			 0

/********************************* DRV_REFCLK *********************************/
#define SERDES_25G_LANE_DRV_REFCLK_BASE					0x380

#define SERDES_25G_LANE_DRV_AFE_PD_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x00)
#define SERDES_25G_LANE_DRV_AFE_RST_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x01)
#define SERDES_25G_LANE_DRV_AFE_CTRL1_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x03)
#define SERDES_25G_LANE_DRV_AFE_CTRL2_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x04)
#define SERDES_25G_LANE_DRV_AFE_CTRL3_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x05)
#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x06)
#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x08)
#define SERDES_25G_LANE_DRV_AFE_ATT_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x09)
#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x0A)
#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL1_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x0B)
#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x0C)
#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL1_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x0D)
#define SERDES_25G_LANE_DRV_TXEQ_CTRL0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x10)
#define SERDES_25G_LANE_DRV_TXEQ_STATUS0_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x11)
#define SERDES_25G_LANE_DRV_TXEQ_CTRL1_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x12)
#define SERDES_25G_LANE_DRV_TXEQ_CTRL2_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x13)
#define SERDES_25G_LANE_DRV_TXEQ_CTRL3_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x14)
#define SERDES_25G_LANE_DRV_TXEQ_CTRL4_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x15)
#define SERDES_25G_LANE_DRV_TXEQ_CTRL5_ADDR		(SERDES_25G_LANE_DRV_REFCLK_BASE + 0x16)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_DRV_AFE_PD_CTRL0_PD_TXDRV_MASK			0x01
#define SERDES_25G_LANE_DRV_AFE_PD_CTRL0_PD_TXDRV_SHIFT			0

#define SERDES_25G_LANE_DRV_AFE_PD_CTRL0_TXDRV_LP_IDLE_MASK		0x02
#define SERDES_25G_LANE_DRV_AFE_PD_CTRL0_TXDRV_LP_IDLE_SHIFT		1

#define SERDES_25G_LANE_DRV_AFE_RST_CTRL0_RST_TXDRV_DIV2_N_MASK		0x01
#define SERDES_25G_LANE_DRV_AFE_RST_CTRL0_RST_TXDRV_DIV2_N_SHIFT	0

#define SERDES_25G_LANE_DRV_AFE_CTRL1_TXDRV_SPARE_MASK			0xFF
#define SERDES_25G_LANE_DRV_AFE_CTRL1_TXDRV_SPARE_SHIFT			0

#define SERDES_25G_LANE_DRV_AFE_CTRL2_TXDRV_TOGGLE_EN_MASK		0x01
#define SERDES_25G_LANE_DRV_AFE_CTRL2_TXDRV_TOGGLE_EN_SHIFT		0

#define SERDES_25G_LANE_DRV_AFE_CTRL2_TXDRV_CLK_DELAY_MASK		0x3E
#define SERDES_25G_LANE_DRV_AFE_CTRL2_TXDRV_CLK_DELAY_SHIFT		1

#define SERDES_25G_LANE_DRV_AFE_CTRL3_TXDRV_CO_POL_MASK			0x07
#define SERDES_25G_LANE_DRV_AFE_CTRL3_TXDRV_CO_POL_SHIFT		0

#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_C1_P5_MASK		0x01
#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_C1_P5_SHIFT		0

#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_C1_X1_MASK		0x02
#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_C1_X1_SHIFT		1

#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_C1_X2_MASK		0x1C
#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_C1_X2_SHIFT		2

#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_CXC1_X1_MASK		0x20
#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_CXC1_X1_SHIFT	5

#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_CXC1_X2_MASK		0xC0
#define SERDES_25G_LANE_DRV_AFE_C1_CTRL0_TXDRV_SEL_CXC1_X2_SHIFT	6

#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CM1_P5_MASK		0x01
#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CM1_P5_SHIFT	0

#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CM1_X1_MASK		0x02
#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CM1_X1_SHIFT	1

#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CM1_X2_MASK		0x0C
#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CM1_X2_SHIFT	2

#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CXCM1_X2_MASK	0x10
#define SERDES_25G_LANE_DRV_AFE_CM1_CTRL0_TXDRV_SEL_CXCM1_X2_SHIFT	4

#define SERDES_25G_LANE_DRV_AFE_ATT_CTRL0_TXDRV_SEL_ATT_X1_MASK		0x07
#define SERDES_25G_LANE_DRV_AFE_ATT_CTRL0_TXDRV_SEL_ATT_X1_SHIFT	0

#define SERDES_25G_LANE_DRV_AFE_ATT_CTRL0_TXDRV_SEL_ATT_X2_MASK		0xF8
#define SERDES_25G_LANE_DRV_AFE_ATT_CTRL0_TXDRV_SEL_ATT_X2_SHIFT	3

#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL0_TXDRV_SEL_CXN_X1_MASK	0x07
#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL0_TXDRV_SEL_CXN_X1_SHIFT	0

#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL0_TXDRV_SEL_FIXEDCXN_X1_MASK	0x18
#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL0_TXDRV_SEL_FIXEDCXN_X1_SHIFT	3

#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL1_TXDRV_SEL_CXN_X2_MASK	0x1F
#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL1_TXDRV_SEL_CXN_X2_SHIFT	0

#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL1_TXDRV_SEL_FIXEDCXN_XP5_MASK	0x60
#define SERDES_25G_LANE_DRV_AFE_CALN_CTRL1_TXDRV_SEL_FIXEDCXN_XP5_SHIFT	5

#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL0_TXDRV_SEL_CXP_X1_MASK	0x07
#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL0_TXDRV_SEL_CXP_X1_SHIFT	0

#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL0_TXDRV_SEL_FIXEDCXP_X1_MASK	0x18
#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL0_TXDRV_SEL_FIXEDCXP_X1_SHIFT	3

#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL1_TXDRV_SEL_CXP_X2_MASK	0x1F
#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL1_TXDRV_SEL_CXP_X2_SHIFT	0

#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL1_TXDRV_SEL_FIXEDCXP_XP5_MASK	0x60
#define SERDES_25G_LANE_DRV_AFE_CALP_CTRL1_TXDRV_SEL_FIXEDCXP_XP5_SHIFT	5

#define SERDES_25G_LANE_DRV_TXEQ_CTRL0_REQ_MASK				0x01
#define SERDES_25G_LANE_DRV_TXEQ_CTRL0_REQ_SHIFT			0

#define SERDES_25G_LANE_DRV_TXEQ_STATUS0_ACK_MASK			0x01
#define SERDES_25G_LANE_DRV_TXEQ_STATUS0_ACK_SHIFT			0

#define SERDES_25G_LANE_DRV_TXEQ_CTRL1_TXEQ_C1_MASK			0x1F
#define SERDES_25G_LANE_DRV_TXEQ_CTRL1_TXEQ_C1_SHIFT			0

#define SERDES_25G_LANE_DRV_TXEQ_CTRL2_TXEQ_C2_MASK			0x03
#define SERDES_25G_LANE_DRV_TXEQ_CTRL2_TXEQ_C2_SHIFT			0

#define SERDES_25G_LANE_DRV_TXEQ_CTRL3_TXEQ_CM1_MASK			0x0F
#define SERDES_25G_LANE_DRV_TXEQ_CTRL3_TXEQ_CM1_SHIFT			0

#define SERDES_25G_LANE_DRV_TXEQ_CTRL4_TXEQ_1LSB_MODE_MASK		0x01
#define SERDES_25G_LANE_DRV_TXEQ_CTRL4_TXEQ_1LSB_MODE_SHIFT		0

#define SERDES_25G_LANE_DRV_TXEQ_CTRL4_SWING_1LSB_MODE_MASK		0x02
#define SERDES_25G_LANE_DRV_TXEQ_CTRL4_SWING_1LSB_MODE_SHIFT		1

#define SERDES_25G_LANE_DRV_TXEQ_CTRL5_DRV_SWING_MASK			0x0F
#define SERDES_25G_LANE_DRV_TXEQ_CTRL5_DRV_SWING_SHIFT			0

/********************************* DFE REFCLK *********************************/
#define SERDES_25G_LANE_DFE_REFCLK_BASE					0x400

#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL0_ADDR                   (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x00)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL1_ADDR                   (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x01)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL2_ADDR                   (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x02)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_RST_CTRL0_ADDR                  (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x04)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_TOGGLE_CTRL0_ADDR               (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x06)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_MUTE_CTRL0_ADDR                 (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x0A)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_CLK_CTRL0_ADDR                  (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x0C)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_EYECLK_CTRL0_ADDR               (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x0E)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_CML_CTRL0_ADDR                  (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x10)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_MISC_CTRL0_ADDR                 (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x12)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_SPARE_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x14)
#define SERDES_25G_LANE_DFE_REFCLK_AFE_QSAMPLE_STATUS0_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x16)
#define SERDES_25G_LANE_DFE_REFCLK_EYE_VSCAN_CTRL0_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x18)
#define SERDES_25G_LANE_DFE_REFCLK_EYE_VSCAN_CTRL1_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x19)
#define SERDES_25G_LANE_DFE_REFCLK_EYE_TAP1_CTRL0_ADDR                 (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x1B)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x20)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL1_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x21)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL2_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x22)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL3_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x23)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL4_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x24)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL5_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x25)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL6_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x26)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL7_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x27)
#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_ADDR                    (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x28)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_ADDR                      (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x2A)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL0_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x2B)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL1_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x2C)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL2_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x2D)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL3_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x2E)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL4_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x2F)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL5_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x30)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL6_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x31)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL7_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x32)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL0_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x33)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL1_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x34)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL2_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x35)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL3_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x36)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL4_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x37)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL5_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x38)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL6_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x39)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL7_ADDR             (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x3A)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS0_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x3B)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS1_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x3C)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS2_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x3D)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS3_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x3E)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS4_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x3F)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS5_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x40)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS6_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x41)
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS7_ADDR                (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x42)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ADDR              (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x50)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL1_ADDR              (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x51)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL2_ADDR              (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x52)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL0_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x53)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL1_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x54)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL2_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x55)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL3_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x56)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL4_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x57)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL5_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x58)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL6_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x59)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL7_ADDR     (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x5A)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS0_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x5B)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS1_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x5C)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS2_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x5D)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS3_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x5E)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS4_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x5F)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS5_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x60)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS6_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x61)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS7_ADDR        (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x62)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ADDR  (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x63)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS0_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x64)
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ADDR            (SERDES_25G_LANE_DFE_REFCLK_BASE + 0x65)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL0_PD_RXDFE_MASK                           0x01
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL0_PD_RXDFE_SHIFT                          0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL0_PD_RXDFE_TAP_MASK                       0x3E
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL0_PD_RXDFE_TAP_SHIFT                      1

#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL1_PD_RXDFE_EVEN_PATH_MASK                 0x03
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL1_PD_RXDFE_EVEN_PATH_SHIFT                0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL1_PD_RXDFE_ODD_PATH_MASK                  0x0C
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL1_PD_RXDFE_ODD_PATH_SHIFT                 2

#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL2_PD_RXDFE_EYE_EVEN_MASK                  0x07
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL2_PD_RXDFE_EYE_EVEN_SHIFT                 0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL2_PD_RXDFE_EYE_ODD_MASK                   0x38
#define SERDES_25G_LANE_DFE_REFCLK_AFE_PD_CTRL2_PD_RXDFE_EYE_ODD_SHIFT                  3

#define SERDES_25G_LANE_DFE_REFCLK_AFE_RST_CTRL0_RST_RXDFE_N_MASK                       0x01
#define SERDES_25G_LANE_DFE_REFCLK_AFE_RST_CTRL0_RST_RXDFE_N_SHIFT                      0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_TOGGLE_CTRL0_RXDFE_TOGGLE_EN_MASK                0x01
#define SERDES_25G_LANE_DFE_REFCLK_AFE_TOGGLE_CTRL0_RXDFE_TOGGLE_EN_SHIFT               0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_MUTE_CTRL0_RXDFE_MUTE_EYE_EVEN_MASK              0x01
#define SERDES_25G_LANE_DFE_REFCLK_AFE_MUTE_CTRL0_RXDFE_MUTE_EYE_EVEN_SHIFT             0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_MUTE_CTRL0_RXDFE_MUTE_EYE_ODD_MASK               0x02
#define SERDES_25G_LANE_DFE_REFCLK_AFE_MUTE_CTRL0_RXDFE_MUTE_EYE_ODD_SHIFT              1

#define SERDES_25G_LANE_DFE_REFCLK_AFE_MUTE_CTRL0_RXDFE_EDGE_MUTE_MASK                  0x0C
#define SERDES_25G_LANE_DFE_REFCLK_AFE_MUTE_CTRL0_RXDFE_EDGE_MUTE_SHIFT                 2

#define SERDES_25G_LANE_DFE_REFCLK_AFE_CLK_CTRL0_RXDFE_CLK_DELAY_MASK                   0x0F
#define SERDES_25G_LANE_DFE_REFCLK_AFE_CLK_CTRL0_RXDFE_CLK_DELAY_SHIFT                  0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_CLK_CTRL0_RXDFE_CLKDIV_OVR_MASK                  0x30
#define SERDES_25G_LANE_DFE_REFCLK_AFE_CLK_CTRL0_RXDFE_CLKDIV_OVR_SHIFT                 4

#define SERDES_25G_LANE_DFE_REFCLK_AFE_EYECLK_CTRL0_RXDFE_EYECLK_DELAY_MASK             0x0F
#define SERDES_25G_LANE_DFE_REFCLK_AFE_EYECLK_CTRL0_RXDFE_EYECLK_DELAY_SHIFT            0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_EYECLK_CTRL0_RXDFE_CLKDIVEYE_OVR_MASK            0x30
#define SERDES_25G_LANE_DFE_REFCLK_AFE_EYECLK_CTRL0_RXDFE_CLKDIVEYE_OVR_SHIFT           4

#define SERDES_25G_LANE_DFE_REFCLK_AFE_EYECLK_CTRL0_RXDFE_EYERESAMP_ADJ_MASK            0xC0
#define SERDES_25G_LANE_DFE_REFCLK_AFE_EYECLK_CTRL0_RXDFE_EYERESAMP_ADJ_SHIFT           6

#define SERDES_25G_LANE_DFE_REFCLK_AFE_CML_CTRL0_RXDFE_CMLI_MASK                        0x0F
#define SERDES_25G_LANE_DFE_REFCLK_AFE_CML_CTRL0_RXDFE_CMLI_SHIFT                       0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_CML_CTRL0_RXDFE_CMLR_MASK                        0x30
#define SERDES_25G_LANE_DFE_REFCLK_AFE_CML_CTRL0_RXDFE_CMLR_SHIFT                       4

#define SERDES_25G_LANE_DFE_REFCLK_AFE_CML_CTRL0_RXDFE_CMLR_LTCH_MASK                   0x40
#define SERDES_25G_LANE_DFE_REFCLK_AFE_CML_CTRL0_RXDFE_CMLR_LTCH_SHIFT                  6

#define SERDES_25G_LANE_DFE_REFCLK_AFE_MISC_CTRL0_RXDFE_SUMGAIN_MASK                    0x01
#define SERDES_25G_LANE_DFE_REFCLK_AFE_MISC_CTRL0_RXDFE_SUMGAIN_SHIFT                   0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_MISC_CTRL0_RXDFE_LDR_MASK                        0x06
#define SERDES_25G_LANE_DFE_REFCLK_AFE_MISC_CTRL0_RXDFE_LDR_SHIFT                       1

#define SERDES_25G_LANE_DFE_REFCLK_AFE_SPARE_RXDFE_SPARE_MASK                           0xFF
#define SERDES_25G_LANE_DFE_REFCLK_AFE_SPARE_RXDFE_SPARE_SHIFT                          0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_QSAMPLE_STATUS0_RXDFE_CLKDIV_QSAMPLE_MASK        0x01
#define SERDES_25G_LANE_DFE_REFCLK_AFE_QSAMPLE_STATUS0_RXDFE_CLKDIV_QSAMPLE_SHIFT       0

#define SERDES_25G_LANE_DFE_REFCLK_AFE_QSAMPLE_STATUS0_RXDFE_CLKDIVEYE_QSAMPLE_MASK     0x1E
#define SERDES_25G_LANE_DFE_REFCLK_AFE_QSAMPLE_STATUS0_RXDFE_CLKDIVEYE_QSAMPLE_SHIFT    1

#define SERDES_25G_LANE_DFE_REFCLK_EYE_VSCAN_CTRL0_MAG_MASK                             0xFF
#define SERDES_25G_LANE_DFE_REFCLK_EYE_VSCAN_CTRL0_MAG_SHIFT                            0

#define SERDES_25G_LANE_DFE_REFCLK_EYE_VSCAN_CTRL1_POL_MASK                             0x01
#define SERDES_25G_LANE_DFE_REFCLK_EYE_VSCAN_CTRL1_POL_SHIFT                            0

#define SERDES_25G_LANE_DFE_REFCLK_EYE_TAP1_CTRL0_MAG_MASK                              0x1F
#define SERDES_25G_LANE_DFE_REFCLK_EYE_TAP1_CTRL0_MAG_SHIFT                             0

#define SERDES_25G_LANE_DFE_REFCLK_EYE_TAP1_CTRL0_POL_MASK                              0x80
#define SERDES_25G_LANE_DFE_REFCLK_EYE_TAP1_CTRL0_POL_SHIFT                             7

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_REQ_MASK                                   0x01
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_REQ_SHIFT                                  0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_CMD_MASK                                   0x3E
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_CMD_SHIFT                                  1

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_FINISH_MASK                                0x40
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_FINISH_SHIFT                               6

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_DRIVE_BEFORE_EVAL_MASK                     0x80
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL0_DRIVE_BEFORE_EVAL_SHIFT                    7

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL1_NEXT_STATE_MASK                            0x0F
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL1_NEXT_STATE_SHIFT                           0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL1_CTRL_EN_MASK                               0x10
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL1_CTRL_EN_SHIFT                              4

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL2_WAIT_1_TIMER7_0_MASK                       0xFF
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL2_WAIT_1_TIMER7_0_SHIFT                      0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL3_WAIT_1_TIMER9_8_MASK                       0x03
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL3_WAIT_1_TIMER9_8_SHIFT                      0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL4_WAIT_2_TIMER7_0_MASK                       0xFF
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL4_WAIT_2_TIMER7_0_SHIFT                      0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL5_WAIT_2_TIMER9_8_MASK                       0x03
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL5_WAIT_2_TIMER9_8_SHIFT                      0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL6_TAP_DELAY_7_0_MASK                         0xFF
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL6_TAP_DELAY_7_0_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL7_TAP_DELAY_9_8_MASK                         0x03
#define SERDES_25G_LANE_DFE_REFCLK_FSM_CTRL7_TAP_DELAY_9_8_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_ACK_MASK                                 0x01
#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_ACK_SHIFT                                0

#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_SLICER_OFST_ACK_MASK                     0x02
#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_SLICER_OFST_ACK_SHIFT                    1

#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_ERR_FUNC_ACK_MASK                        0x04
#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_ERR_FUNC_ACK_SHIFT                       2

#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_AFE_DRV_ACK_MASK                         0x08
#define SERDES_25G_LANE_DFE_REFCLK_FSM_STATUS0_AFE_DRV_ACK_SHIFT                        3

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_EVEN0_EN_MASK                         0x01
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_EVEN0_EN_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_EVEN1_EN_MASK                         0x02
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_EVEN1_EN_SHIFT                        1

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_ODD0_EN_MASK                          0x04
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_ODD0_EN_SHIFT                         2

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_ODD1_EN_MASK                          0x08
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP1_ODD1_EN_SHIFT                         3

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP2_EN_MASK                               0x10
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP2_EN_SHIFT                              4

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP3_EN_MASK                               0x20
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP3_EN_SHIFT                              5

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP4_EN_MASK                               0x40
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP4_EN_SHIFT                              6

#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP5_EN_MASK                               0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_CTRL0_TAP5_EN_SHIFT                              7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL0_TAP1_EVEN0_MASK                  0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL0_TAP1_EVEN0_SHIFT                 0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL0_TAP1_EVEN0_POLARITY_MASK         0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL0_TAP1_EVEN0_POLARITY_SHIFT        7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL1_TAP1_EVEN1_MASK                  0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL1_TAP1_EVEN1_SHIFT                 0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL1_TAP1_EVEN1_POLARITY_MASK         0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL1_TAP1_EVEN1_POLARITY_SHIFT        7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL2_TAP1_ODD0_MASK                   0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL2_TAP1_ODD0_SHIFT                  0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL2_TAP1_ODD0_POLARITY_MASK          0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL2_TAP1_ODD0_POLARITY_SHIFT         7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL3_TAP1_ODD1_MASK                   0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL3_TAP1_ODD1_SHIFT                  0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL3_TAP1_ODD1_POLARITY_MASK          0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL3_TAP1_ODD1_POLARITY_SHIFT         7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL4_TAP2_MASK                        0x0F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL4_TAP2_SHIFT                       0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL4_TAP2_POLARITY_MASK               0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL4_TAP2_POLARITY_SHIFT              7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL5_TAP3_MASK                        0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL5_TAP3_SHIFT                       0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL5_TAP3_POLARITY_MASK               0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL5_TAP3_POLARITY_SHIFT              7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL6_TAP4_MASK                        0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL6_TAP4_SHIFT                       0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL6_TAP4_POLARITY_MASK               0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL6_TAP4_POLARITY_SHIFT              7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL7_TAP5_MASK                        0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL7_TAP5_SHIFT                       0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL7_TAP5_POLARITY_MASK               0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_START_VAL_CTRL7_TAP5_POLARITY_SHIFT              7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL0_TAP1_EVEN0_MASK                   0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL0_TAP1_EVEN0_SHIFT                  0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL0_TAP1_EVEN0_POLARITY_MASK          0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL0_TAP1_EVEN0_POLARITY_SHIFT         7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL1_TAP1_EVEN1_MASK                   0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL1_TAP1_EVEN1_SHIFT                  0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL1_TAP1_EVEN1_POLARITY_MASK          0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL1_TAP1_EVEN1_POLARITY_SHIFT         7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL2_TAP1_ODD0_MASK                    0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL2_TAP1_ODD0_SHIFT                   0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL2_TAP1_ODD0_POLARITY_MASK           0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL2_TAP1_ODD0_POLARITY_SHIFT          7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL3_TAP1_ODD1_MASK                    0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL3_TAP1_ODD1_SHIFT                   0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL3_TAP1_ODD1_POLARITY_MASK           0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL3_TAP1_ODD1_POLARITY_SHIFT          7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL4_TAP2_MASK                         0x0F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL4_TAP2_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL4_TAP2_POLARITY_MASK                0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL4_TAP2_POLARITY_SHIFT               7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL5_TAP3_MASK                         0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL5_TAP3_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL5_TAP3_POLARITY_MASK                0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL5_TAP3_POLARITY_SHIFT               7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL6_TAP4_MASK                         0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL6_TAP4_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL6_TAP4_POLARITY_MASK                0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL6_TAP4_POLARITY_SHIFT               7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL7_TAP5_MASK                         0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL7_TAP5_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL7_TAP5_POLARITY_MASK                0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_LOAD_VAL_CTRL7_TAP5_POLARITY_SHIFT               7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS0_TAP1_EVEN0_MASK                      0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS0_TAP1_EVEN0_SHIFT                     0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS0_TAP1_EVEN0_POLARITY_MASK             0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS0_TAP1_EVEN0_POLARITY_SHIFT            7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS1_TAP1_EVEN1_MASK                      0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS1_TAP1_EVEN1_SHIFT                     0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS1_TAP1_EVEN1_POLARITY_MASK             0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS1_TAP1_EVEN1_POLARITY_SHIFT            7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS2_TAP1_ODD0_MASK                       0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS2_TAP1_ODD0_SHIFT                      0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS2_TAP1_ODD0_POLARITY_MASK              0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS2_TAP1_ODD0_POLARITY_SHIFT             7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS3_TAP1_ODD1_MASK                       0x1F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS3_TAP1_ODD1_SHIFT                      0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS3_TAP1_ODD1_POLARITY_MASK              0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS3_TAP1_ODD1_POLARITY_SHIFT             7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS4_TAP2_MASK                            0x0F
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS4_TAP2_SHIFT                           0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS4_TAP2_POLARITY_MASK                   0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS4_TAP2_POLARITY_SHIFT                  7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS5_TAP3_MASK                            0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS5_TAP3_SHIFT                           0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS5_TAP3_POLARITY_MASK                   0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS5_TAP3_POLARITY_SHIFT                  7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS6_TAP4_MASK                            0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS6_TAP4_SHIFT                           0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS6_TAP4_POLARITY_MASK                   0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS6_TAP4_POLARITY_SHIFT                  7

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS7_TAP5_MASK                            0x07
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS7_TAP5_SHIFT                           0

#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS7_TAP5_POLARITY_MASK                   0x80
#define SERDES_25G_LANE_DFE_REFCLK_TAP_VAL_STATUS7_TAP5_POLARITY_SHIFT                  7

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN0_DATA_EN_MASK                 0x01
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN0_DATA_EN_SHIFT                0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN1_DATA_EN_MASK                 0x02
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN1_DATA_EN_SHIFT                1

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD0_DATA_EN_MASK                  0x04
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD0_DATA_EN_SHIFT                 2

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD1_DATA_EN_MASK                  0x08
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD1_DATA_EN_SHIFT                 3

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN_EDGE_EN_MASK                  0x10
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN_EDGE_EN_SHIFT                 4

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD_EDGE_EN_MASK                   0x20
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD_EDGE_EN_SHIFT                  5

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN_EYE_EN_MASK                   0x40
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_EVEN_EYE_EN_SHIFT                  6

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD_EYE_EN_MASK                    0x80
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL0_ODD_EYE_EN_SHIFT                   7

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL1_LIMIT_MASK                         0x1F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL1_LIMIT_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL2_MAX_BOUNCES_MASK                   0x0F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_CTRL2_MAX_BOUNCES_SHIFT                  0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL0_EVEN0_DATA_MASK           0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL0_EVEN0_DATA_SHIFT          0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL1_EVEN1_DATA_MASK           0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL1_EVEN1_DATA_SHIFT          0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL2_ODD0_DATA_MASK            0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL2_ODD0_DATA_SHIFT           0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL3_ODD1_DATA_MASK            0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL3_ODD1_DATA_SHIFT           0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL4_EVEN_EDGE_MASK            0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL4_EVEN_EDGE_SHIFT           0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL5_ODD_EDGE_MASK             0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL5_ODD_EDGE_SHIFT            0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL6_EVEN_EYE_MASK             0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL6_EVEN_EYE_SHIFT            0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL7_ODD_EYE_MASK              0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_VAL_CTRL7_ODD_EYE_SHIFT             0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS0_EVEN0_DATA_MASK              0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS0_EVEN0_DATA_SHIFT             0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS1_EVEN1_DATA_MASK              0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS1_EVEN1_DATA_SHIFT             0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS2_ODD0_DATA_MASK               0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS2_ODD0_DATA_SHIFT              0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS3_ODD1_DATA_MASK               0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS3_ODD1_DATA_SHIFT              0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS4_EVEN_EDGE_MASK               0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS4_EVEN_EDGE_SHIFT              0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS5_ODD_EDGE_MASK                0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS5_ODD_EDGE_SHIFT               0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS6_EVEN_EYE_MASK                0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS6_EVEN_EYE_SHIFT               0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS7_ODD_EYE_MASK                 0x3F
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_VAL_STATUS7_ODD_EYE_SHIFT                0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN0_DATA_MASK        0x01
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN0_DATA_SHIFT       0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN1_DATA_MASK        0x02
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN1_DATA_SHIFT       1

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD0_DATA_MASK         0x04
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD0_DATA_SHIFT        2

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD1_DATA_MASK         0x08
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD1_DATA_SHIFT        3

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN_EDGE_MASK         0x10
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN_EDGE_SHIFT        4

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD_EDGE_MASK          0x20
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD_EDGE_SHIFT         5

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN_EYE_MASK          0x40
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_EVEN_EYE_SHIFT         6

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD_EYE_MASK           0x80
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_LOAD_SOURCE_CTRL0_ODD_EYE_SHIFT          7

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS0_ERR_MASK                         0x01
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS0_ERR_SHIFT                        0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS0_INC_MASK                         0x02
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS0_INC_SHIFT                        1

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS0_DEC_MASK                         0x04
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS0_DEC_SHIFT                        2

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN0_DATA_MASK                  0x01
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN0_DATA_SHIFT                 0

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN1_DATA_MASK                  0x02
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN1_DATA_SHIFT                 1

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD0_DATA_MASK                   0x04
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD0_DATA_SHIFT                  2

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD1_DATA_MASK                   0x08
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD1_DATA_SHIFT                  3

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN_EDGE_MASK                   0x10
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN_EDGE_SHIFT                  4

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD_EDGE_MASK                    0x20
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD_EDGE_SHIFT                   5

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN_EYE_MASK                    0x40
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_EVEN_EYE_SHIFT                   6

#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD_EYE_MASK                     0x80
#define SERDES_25G_LANE_DFE_REFCLK_SLICER_OFST_STATUS1_ODD_EYE_SHIFT                    7

/********************************** LOS REFCLK **********************************/
#define SERDES_25G_LANE_LOS_REFCLK_BASE					0x500

#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_CTRL0_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x00)
#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_CTRL1_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x01)
#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_STATUS0_ADDR  (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x02)
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL0_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x10)
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL1_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x11)
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL2_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x12)
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL3_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x13)
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL4_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x14)
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL5_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x15)
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL6_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x16)
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL0_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x20)
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL1_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x21)
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL2_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x22)
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL3_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x23)
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL4_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x24)
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL0_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x30)
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL1_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x31)
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL2_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x32)
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL3_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x33)
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL0_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x40)
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x41)
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL2_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x42)
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL3_ADDR    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x43)
#define SERDES_25G_LANE_LOS_REFCLK_EYE_CTRL_ADDR            (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x46)
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_CTRL0_ADDR   (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x51)
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS0_ADDR (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x59)
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS1_ADDR (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x60)
#define SERDES_25G_LANE_LOS_REFCLK_CTRL0_ADDR		    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x70)
#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_ADDR		    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x71)
#define SERDES_25G_LANE_LOS_REFCLK_AFE_SPARE_CTRL0_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x72)
#define SERDES_25G_LANE_LOS_REFCLK_AFE_PD_CTRL0_ADDR	    (SERDES_25G_LANE_LOS_REFCLK_BASE + 0x73)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/

#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_CTRL0_EN_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_CTRL0_EN_SHIFT			0

#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_CTRL1_ASSERT_THRESHOLD_MASK	0xFF
#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_CTRL1_ASSERT_THRESHOLD_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_STATUS0_EXCEED_MASK		0x01
#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_STATUS0_EXCEED_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_STATUS0_EXCEED_STICKY_MASK	0x02
#define SERDES_25G_LANE_LOS_REFCLK_RUN_LENGTH_STATUS0_EXCEED_STICKY_SHIFT	1

#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL0_ASSERT_THRESHOLD_7_0_MASK	0xFF
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL0_ASSERT_THRESHOLD_7_0_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL1_ASSERT_THRESHOLD_15_8_MASK	0xFF
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL1_ASSERT_THRESHOLD_15_8_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL2_DEASSERT_THRESHOLD_7_0_MASK	0xFF
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL2_DEASSERT_THRESHOLD_7_0_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL3_DEASSERT_THRESHOLD_15_8_MASK	0xFF
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL3_DEASSERT_THRESHOLD_15_8_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL4_DEASSERT_THRESHOLD_23_16_MASK	0xFF
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL4_DEASSERT_THRESHOLD_23_16_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL5_DEASSERT_THRESHOLD_25_24_MASK	0x03
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL5_DEASSERT_THRESHOLD_25_24_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL6_EN_MASK				0x01
#define SERDES_25G_LANE_LOS_REFCLK_FILTER_CTRL6_EN_SHIFT			0

#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL0_EN_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL0_EN_SHIFT			0

#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL1_PERIOD_7_0_MASK		0xFF
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL1_PERIOD_7_0_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL2_PERIOD_15_8_MASK		0xFF
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL2_PERIOD_15_8_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL3_PERIOD_23_16_MASK		0xFF
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL3_PERIOD_23_16_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL4_PERIOD_25_24_MASK		0x03
#define SERDES_25G_LANE_LOS_REFCLK_TIMED_MODE_CTRL4_PERIOD_25_24_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL0_LOS_O_EN_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL0_LOS_O_EN_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL0_LOS_O_VALUE_MASK		0x10
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL0_LOS_O_VALUE_SHIFT		4

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL1_LOS_I_EN_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL1_LOS_I_EN_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL1_LOS_I_VALUE_MASK		0x10
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL1_LOS_I_VALUE_SHIFT		4

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL2_LOS_OFFSET_VALUE_MASK		0x3F
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL2_LOS_OFFSET_VALUE_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL2_LOS_OFFSET_EN_MASK		0x40
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL2_LOS_OFFSET_EN_SHIFT		6

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL3_AGC_OFFSET_VALUE_MASK		0x3F
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL3_AGC_OFFSET_VALUE_SHIFT	0

#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL3_AGC_OFFSET_EN_MASK		0x40
#define SERDES_25G_LANE_LOS_REFCLK_OVERRIDE_CTRL3_AGC_OFFSET_EN_SHIFT		6

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL0_BANDWIDTH_MASK		0x01
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL0_BANDWIDTH_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL0_HYSTERESIS_MASK		0x0E
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL0_HYSTERESIS_SHIFT		1

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL0_ENVDET_BYP_MASK		0x10
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL0_ENVDET_BYP_SHIFT		4

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_GAIN_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_GAIN_SHIFT			0

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_LOS_INVERT_MASK		0x02
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_LOS_INVERT_SHIFT		1

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_AGC_INVERT_MASK		0x04
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_AGC_INVERT_SHIFT		2

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_THRESHOLD_MASK		0x78
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL1_THRESHOLD_SHIFT		3

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL2_MODE_SWITCH_WAIT_7_0_MASK   0xFF
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL2_MODE_SWITCH_WAIT_7_0_SHIFT  0

#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL3_MODE_SWITCH_WAIT_15_8_MASK  0xFF
#define SERDES_25G_LANE_LOS_REFCLK_COMPARATOR_CTRL3_MODE_SWITCH_WAIT_15_8_SHIFT 0

#define SERDES_25G_LANE_LOS_REFCLK_EYE_CTRL_EYE_DATA_PARITY_MASK                0x01
#define SERDES_25G_LANE_LOS_REFCLK_EYE_CTRL_EYE_DATA_PARITY_SHIFT               0

#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_CTRL0_EN_MASK                    0x01
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_CTRL0_EN_SHIFT                   0

#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_CTRL0_MODE_MASK                  0x02
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_CTRL0_MODE_SHIFT                 1

#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS0_LOS_OFFSET_MASK		0x3F
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS0_LOS_OFFSET_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS1_AGC_CALIB_DONE_MASK	0x40
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS1_AGC_CALIB_DONE_SHIFT	6

#define SERDES_25G_LANE_LOS_REFCLK_CTRL0_EN_MASK				0x01
#define SERDES_25G_LANE_LOS_REFCLK_CTRL0_EN_SHIFT				0

#define SERDES_25G_LANE_FEATURE_CTRL0_SRC_SELECT_MASK                           0x02
#define SERDES_25G_LANE_FEATURE_CTRL0_SRC_SELECT_SHIFT                          1

#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_LOS_READY_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_LOS_READY_SHIFT			0

#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_AGC_READY_MASK			0x02
#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_AGC_READY_SHIFT			1

#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_LOS_MASK				0x04
#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_LOS_SHIFT				2

#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_LOS_RAW_MASK				0x08
#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_LOS_RAW_SHIFT			3

#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_AGC_MASK				0x10
#define SERDES_25G_LANE_LOS_REFCLK_STATUS0_AGC_SHIFT				4

#define SERDES_25G_LANE_LOS_REFCLK_AFE_SPARE_CTRL0_RXLOS_SPARE_MASK		0x0F
#define SERDES_25G_LANE_LOS_REFCLK_AFE_SPARE_CTRL0_RXLOS_SPARE_SHIFT		0

#define SERDES_25G_LANE_LOS_REFCLK_AFE_PD_CTRL0_PD_RXLOS_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_AFE_PD_CTRL0_PD_RXLOS_SHIFT			0

#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_CTRL6_REQ_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_CTRL6_REQ_SHIFT			0

#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS2_ACK_MASK			0x01
#define SERDES_25G_LANE_LOS_REFCLK_CALIBRATION_STATUS2_ACK_SHIFT		0

/********************************** GCFSM2 **********************************/
#define SERDES_25G_LANE_GCFSM2_BASE					0x580

#define SERDES_25G_LANE_GCFSM2_CMD_CTRL0_ADDR                 (SERDES_25G_LANE_GCFSM2_BASE + 0x00)
#define SERDES_25G_LANE_GCFSM2_CMD_CTRL1_ADDR                 (SERDES_25G_LANE_GCFSM2_BASE + 0x01)
#define SERDES_25G_LANE_GCFSM2_CMD_CTRL2_ADDR                 (SERDES_25G_LANE_GCFSM2_BASE + 0x02)
#define SERDES_25G_LANE_GCFSM2_CMD_STATUS_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x03)
#define SERDES_25G_LANE_GCFSM2_READ_SHADOW_DATA_STATUS0_ADDR  (SERDES_25G_LANE_GCFSM2_BASE + 0x10)
#define SERDES_25G_LANE_GCFSM2_READ_SHADOW_DATA_STATUS1_ADDR  (SERDES_25G_LANE_GCFSM2_BASE + 0x11)
#define SERDES_25G_LANE_GCFSM2_AVG_UP_CNT_STATUS0_ADDR        (SERDES_25G_LANE_GCFSM2_BASE + 0x12)
#define SERDES_25G_LANE_GCFSM2_AVG_UP_CNT_STATUS1_ADDR        (SERDES_25G_LANE_GCFSM2_BASE + 0x13)
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL0_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x20)
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL1_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x21)
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL2_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x22)
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL3_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x23)
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL4_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x24)
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL5_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x25)
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL6_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x26)
#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL0_ADDR           (SERDES_25G_LANE_GCFSM2_BASE + 0x30)
#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL1_ADDR           (SERDES_25G_LANE_GCFSM2_BASE + 0x31)
#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL2_ADDR           (SERDES_25G_LANE_GCFSM2_BASE + 0x32)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL0_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x40)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL1_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x41)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL2_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x42)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL3_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x43)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL4_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x44)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL5_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x45)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL6_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x46)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL7_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x47)
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL8_ADDR                (SERDES_25G_LANE_GCFSM2_BASE + 0x48)
#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL0_ADDR            (SERDES_25G_LANE_GCFSM2_BASE + 0x50)
#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL1_ADDR            (SERDES_25G_LANE_GCFSM2_BASE + 0x51)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_GCFSM2_CMD_CTRL0_REQ_MASK                                  0x01
#define SERDES_25G_LANE_GCFSM2_CMD_CTRL0_REQ_SHIFT                                 0

#define SERDES_25G_LANE_GCFSM2_CMD_CTRL1_CMD_MASK                                  0x07
#define SERDES_25G_LANE_GCFSM2_CMD_CTRL1_CMD_SHIFT                                 0

#define SERDES_25G_LANE_GCFSM2_CMD_CTRL2_ADDR_MASK                                 0xFF
#define SERDES_25G_LANE_GCFSM2_CMD_CTRL2_ADDR_SHIFT                                0

#define SERDES_25G_LANE_GCFSM2_CMD_STATUS_ACK_MASK                                 0x01
#define SERDES_25G_LANE_GCFSM2_CMD_STATUS_ACK_SHIFT                                0

#define SERDES_25G_LANE_GCFSM2_CMD_STATUS_CODE_MASK                                0x1E
#define SERDES_25G_LANE_GCFSM2_CMD_STATUS_CODE_SHIFT                               1

#define SERDES_25G_LANE_GCFSM2_READ_SHADOW_DATA_STATUS0_7_0_MASK                   0xFF
#define SERDES_25G_LANE_GCFSM2_READ_SHADOW_DATA_STATUS0_7_0_SHIFT                  0

#define SERDES_25G_LANE_GCFSM2_READ_SHADOW_DATA_STATUS1_11_8_MASK                  0x0F
#define SERDES_25G_LANE_GCFSM2_READ_SHADOW_DATA_STATUS1_11_8_SHIFT                 0

#define SERDES_25G_LANE_GCFSM2_AVG_UP_CNT_STATUS0_7_0_MASK                         0xFF
#define SERDES_25G_LANE_GCFSM2_AVG_UP_CNT_STATUS0_7_0_SHIFT                        0

#define SERDES_25G_LANE_GCFSM2_AVG_UP_CNT_STATUS1_8_8_MASK                         0x01
#define SERDES_25G_LANE_GCFSM2_AVG_UP_CNT_STATUS1_8_8_SHIFT                        0

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL0_TYPE_MASK                                0x03
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL0_TYPE_SHIFT                               0

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL0_WIDTH_MASK                               0x3C
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL0_WIDTH_SHIFT                              2

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL1_START_7_0_MASK                           0xFF
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL1_START_7_0_SHIFT                          0

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL2_START_11_8_MASK                          0x0F
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL2_START_11_8_SHIFT                         0

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL3_MIN_7_0_MASK                             0xFF
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL3_MIN_7_0_SHIFT                            0

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL4_MIN_11_8_MASK                            0x0F
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL4_MIN_11_8_SHIFT                           0

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL5_MAX_7_0_MASK                             0xFF
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL5_MAX_7_0_SHIFT                            0

#define SERDES_25G_LANE_GCFSM2_DATA_CTRL6_MAX_11_8_MASK                            0x0F
#define SERDES_25G_LANE_GCFSM2_DATA_CTRL6_MAX_11_8_SHIFT                           0

#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL0_STEP_SIZE_MASK                      0x1F
#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL0_STEP_SIZE_SHIFT                     0

#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL1_BOUNCE_NUM_MASK                     0x0F
#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL1_BOUNCE_NUM_SHIFT                    0

#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL1_COARSE_BOUNCE_NUM_MASK              0xF0
#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL1_COARSE_BOUNCE_NUM_SHIFT             4

#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL2_SETTLE_ON_LOWEST_AVG_EN_MASK        0x01
#define SERDES_25G_LANE_GCFSM2_PARAMETER_CTRL2_SETTLE_ON_LOWEST_AVG_EN_SHIFT       0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL0_LEN_DELAY_AFE_EN_MASK                    0x03
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL0_LEN_DELAY_AFE_EN_SHIFT                   0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL1_LEN_AFE_1ST_LATCH_SETTLE_7_0_MASK        0xFF
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL1_LEN_AFE_1ST_LATCH_SETTLE_7_0_SHIFT       0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL2_LEN_AFE_1ST_LATCH_SETTLE_15_8_MASK       0xFF
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL2_LEN_AFE_1ST_LATCH_SETTLE_15_8_SHIFT      0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL3_LEN_AFE_LATCH_SETTLE_MASK                0xFF
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL3_LEN_AFE_LATCH_SETTLE_SHIFT               0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL4_LEN_AFE_CMP_7_0_MASK                     0xFF
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL4_LEN_AFE_CMP_7_0_SHIFT                    0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL5_LEN_AFE_CMP_15_8_MASK                    0xFF
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL5_LEN_AFE_CMP_15_8_SHIFT                   0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL6_LEN_COARSE_BOUNCE_AFE_CMP_7_0_MASK       0xFF
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL6_LEN_COARSE_BOUNCE_AFE_CMP_7_0_SHIFT      0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL7_LEN_COARSE_BOUNCE_AFE_CMP_15_8_MASK      0xFF
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL7_LEN_COARSE_BOUNCE_AFE_CMP_15_8_SHIFT     0

#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL8_WAIT_MODE_MASK                           0x01
#define SERDES_25G_LANE_GCFSM2_WAIT_CTRL8_WAIT_MODE_SHIFT                          0

#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL0_INVERT_AFE_UP_MASK                   0x01
#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL0_INVERT_AFE_UP_SHIFT                  0

#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL0_LEN_WAIT_AFE_UP_MASK                 0x1E
#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL0_LEN_WAIT_AFE_UP_SHIFT                1

#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL1_LEN_AVG_AFE_UP_MASK                  0xFF
#define SERDES_25G_LANE_GCFSM2_FEEDBACK_CTRL1_LEN_AVG_AFE_UP_SHIFT                 0

/**********************************  TX BIST **********************************/
#define SERDES_25G_LANE_TX_BIST_BASE					0x600

#define SERDES_25G_LANE_TX_BIST_CTRL_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x00)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL0_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x04)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL1_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x05)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL2_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x06)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL3_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x07)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL4_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x08)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL5_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x09)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL6_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x0A)
#define SERDES_25G_LANE_TX_BIST_BER_CTRL7_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x0B)
#define SERDES_25G_LANE_TX_BIST_UDP_SHIFT_AMOUNT_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x20)
#define SERDES_25G_LANE_TX_BIST_UDP_ADDR(byte_num) \
						((SERDES_25G_LANE_TX_BIST_BASE + 0x24) + byte_num)
#define SERDES_25G_LANE_TX_BIST_UDP_NUM_BYTES		20
#define SERDES_25G_LANE_TX_BIST_UDP_7_0_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x24)
#define SERDES_25G_LANE_TX_BIST_UDP_15_8_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x25)
#define SERDES_25G_LANE_TX_BIST_UDP_23_16_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x26)
#define SERDES_25G_LANE_TX_BIST_UDP_31_24_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x27)
#define SERDES_25G_LANE_TX_BIST_UDP_39_32_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x28)
#define SERDES_25G_LANE_TX_BIST_UDP_47_40_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x29)
#define SERDES_25G_LANE_TX_BIST_UDP_55_48_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x2A)
#define SERDES_25G_LANE_TX_BIST_UDP_63_56_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x2B)
#define SERDES_25G_LANE_TX_BIST_UDP_71_64_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x2C)
#define SERDES_25G_LANE_TX_BIST_UDP_79_72_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x2D)
#define SERDES_25G_LANE_TX_BIST_UDP_87_80_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x2E)
#define SERDES_25G_LANE_TX_BIST_UDP_95_88_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x2F)
#define SERDES_25G_LANE_TX_BIST_UDP_103_96_ADDR		(SERDES_25G_LANE_TX_BIST_BASE + 0x30)
#define SERDES_25G_LANE_TX_BIST_UDP_111_104_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x31)
#define SERDES_25G_LANE_TX_BIST_UDP_119_112_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x32)
#define SERDES_25G_LANE_TX_BIST_UDP_127_120_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x33)
#define SERDES_25G_LANE_TX_BIST_UDP_135_128_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x34)
#define SERDES_25G_LANE_TX_BIST_UDP_143_136_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x35)
#define SERDES_25G_LANE_TX_BIST_UDP_151_144_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x36)
#define SERDES_25G_LANE_TX_BIST_UDP_159_152_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x37)
#define SERDES_25G_LANE_TX_BIST_UDP_167_160_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x38)
#define SERDES_25G_LANE_TX_BIST_UDP_175_168_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x39)
#define SERDES_25G_LANE_TX_BIST_UDP_183_176_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x3A)
#define SERDES_25G_LANE_TX_BIST_UDP_191_184_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x3B)
#define SERDES_25G_LANE_TX_BIST_UDP_199_192_ADDR	(SERDES_25G_LANE_TX_BIST_BASE + 0x3C)

#define SERDES_25G_LANE_TX_BIST_CTRL_EN_MASK				0x01
#define SERDES_25G_LANE_TX_BIST_CTRL_EN_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_SEL_MASK			0x1E
#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_SEL_SHIFT			1

#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_PRBS7			1
#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_PRBS9			2
#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_PRBS11			3
#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_PRBS15			4
#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_PRBS23			5
#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_PRBS31			6
#define SERDES_25G_LANE_TX_BIST_CTRL_PATTERN_PRBS_USER			7

#define SERDES_25G_LANE_TX_BIST_BER_CTRL0_MODE_MASK			0x03
#define SERDES_25G_LANE_TX_BIST_BER_CTRL0_MODE_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_BER_CTRL1_TIMER_7_0_MASK		0xFF
#define SERDES_25G_LANE_TX_BIST_BER_CTRL1_TIMER_7_0_SHIFT		0

#define SERDES_25G_LANE_TX_BIST_BER_CTRL2_TIMER_15_8_MASK		0xFF
#define SERDES_25G_LANE_TX_BIST_BER_CTRL2_TIMER_15_8_SHIFT		0

#define SERDES_25G_LANE_TX_BIST_BER_CTRL3_BIT_ERROR_FIELD_7_0_MASK	0xFF
#define SERDES_25G_LANE_TX_BIST_BER_CTRL3_BIT_ERROR_FIELD_7_0_SHIFT	0

#define SERDES_25G_LANE_TX_BIST_BER_CTRL4_BIT_ERROR_FIELD_15_8_MASK	0xFF
#define SERDES_25G_LANE_TX_BIST_BER_CTRL4_BIT_ERROR_FIELD_15_8_SHIFT	0

#define SERDES_25G_LANE_TX_BIST_BER_CTRL5_BIT_ERROR_FIELD_23_16_MASK	0xFF
#define SERDES_25G_LANE_TX_BIST_BER_CTRL5_BIT_ERROR_FIELD_23_16_SHIFT	0

#define SERDES_25G_LANE_TX_BIST_BER_CTRL6_BIT_ERROR_FIELD_31_24_MASK	0xFF
#define SERDES_25G_LANE_TX_BIST_BER_CTRL6_BIT_ERROR_FIELD_31_24_SHIFT	0

#define SERDES_25G_LANE_TX_BIST_BER_CTRL7_BIT_ERROR_FIELD_39_32_MASK	0xFF
#define SERDES_25G_LANE_TX_BIST_BER_CTRL7_BIT_ERROR_FIELD_39_32_SHIFT	0

#define SERDES_25G_LANE_TX_BIST_SHIFT_AMOUNT_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_SHIFT_AMOUNT_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_7_0_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_7_0_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_15_8_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_15_8_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_23_16_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_23_16_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_31_24_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_31_24_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_39_32_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_39_32_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_47_40_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_47_40_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_55_48_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_55_48_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_63_56_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_63_56_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_71_64_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_71_64_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_79_72_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_79_72_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_87_80_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_87_80_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_95_88_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_95_88_SHIFT				0

#define SERDES_25G_LANE_TX_BIST_UDP_103_96_MASK				0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_103_96_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_111_104_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_111_104_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_119_112_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_119_112_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_127_120_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_127_120_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_135_128_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_135_128_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_143_136_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_143_136_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_151_144_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_151_144_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_159_152_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_159_152_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_167_160_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_167_160_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_175_168_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_175_168_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_183_176_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_183_176_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_191_184_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_191_184_SHIFT			0

#define SERDES_25G_LANE_TX_BIST_UDP_199_192_MASK			0xFF
#define SERDES_25G_LANE_TX_BIST_UDP_199_192_SHIFT			0

/**********************************  RX BIST **********************************/
#define SERDES_25G_LANE_RX_BIST_BASE					0x680

#define SERDES_25G_LANE_RX_BIST_CTRL_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x00)
#define SERDES_25G_LANE_RX_BIST_STATUS_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x04)
#define SERDES_25G_LANE_RX_BIST_BER_STATUS0_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x08)
#define SERDES_25G_LANE_RX_BIST_BER_STATUS1_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x09)
#define SERDES_25G_LANE_RX_BIST_BER_STATUS2_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x0A)
#define SERDES_25G_LANE_RX_BIST_BER_STATUS4_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x0C)
#define SERDES_25G_LANE_RX_BIST_BER_STATUS5_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x0D)
#define SERDES_25G_LANE_RX_BIST_BER_STATUS6_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x0E)
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL0_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x14)
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL1_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x15)
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL2_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x16)
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL3_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x17)
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL0_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x20)
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL1_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x21)
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL2_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x22)
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL3_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x23)
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL4_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x24)
#define SERDES_25G_LANE_RX_BIST_SHIFT_AMOUNT_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x30)
#define SERDES_25G_LANE_RX_BIST_UDP_7_0_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x34)
#define SERDES_25G_LANE_RX_BIST_UDP_15_8_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x35)
#define SERDES_25G_LANE_RX_BIST_UDP_23_16_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x36)
#define SERDES_25G_LANE_RX_BIST_UDP_31_24_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x37)
#define SERDES_25G_LANE_RX_BIST_UDP_39_32_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x38)
#define SERDES_25G_LANE_RX_BIST_UDP_47_40_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x39)
#define SERDES_25G_LANE_RX_BIST_UDP_55_48_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x3A)
#define SERDES_25G_LANE_RX_BIST_UDP_63_56_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x3B)
#define SERDES_25G_LANE_RX_BIST_UDP_71_64_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x3C)
#define SERDES_25G_LANE_RX_BIST_UDP_79_72_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x3D)
#define SERDES_25G_LANE_RX_BIST_UDP_87_80_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x3E)
#define SERDES_25G_LANE_RX_BIST_UDP_95_88_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x3F)
#define SERDES_25G_LANE_RX_BIST_UDP_103_96_ADDR		(SERDES_25G_LANE_RX_BIST_BASE + 0x40)
#define SERDES_25G_LANE_RX_BIST_UDP_111_104_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x41)
#define SERDES_25G_LANE_RX_BIST_UDP_119_112_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x42)
#define SERDES_25G_LANE_RX_BIST_UDP_127_120_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x43)
#define SERDES_25G_LANE_RX_BIST_UDP_135_128_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x44)
#define SERDES_25G_LANE_RX_BIST_UDP_143_136_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x45)
#define SERDES_25G_LANE_RX_BIST_UDP_151_144_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x46)
#define SERDES_25G_LANE_RX_BIST_UDP_159_152_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x47)
#define SERDES_25G_LANE_RX_BIST_UDP_167_160_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x48)
#define SERDES_25G_LANE_RX_BIST_UDP_175_168_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x49)
#define SERDES_25G_LANE_RX_BIST_UDP_183_176_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x4A)
#define SERDES_25G_LANE_RX_BIST_UDP_191_184_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x4B)
#define SERDES_25G_LANE_RX_BIST_UDP_199_192_ADDR	(SERDES_25G_LANE_RX_BIST_BASE + 0x4C)

/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_RX_BIST_CTRL_EN_MASK				0x01
#define SERDES_25G_LANE_RX_BIST_CTRL_EN_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_CTRL_PATTERN_SEL_MASK			0x1E
#define SERDES_25G_LANE_RX_BIST_CTRL_PATTERN_SEL_SHIFT			1

#define SERDES_25G_LANE_RX_BIST_CTRL_CLEAR_BER_MASK			0x20
#define SERDES_25G_LANE_RX_BIST_CTRL_CLEAR_BER_SHIFT			5

#define SERDES_25G_LANE_RX_BIST_CTRL_STOP_ERROR_COUNT_MASK		0x40
#define SERDES_25G_LANE_RX_BIST_CTRL_STOP_ERROR_COUNT_SHIFT		6

#define SERDES_25G_LANE_RX_BIST_CTRL_FORCE_LFSR_WITH_RXDATA_MASK	0x80
#define SERDES_25G_LANE_RX_BIST_CTRL_FORCE_LFSR_WITH_RXDATA_SHIFT	7

#define SERDES_25G_LANE_RX_BIST_STATUS_STATE_MASK			0x07
#define SERDES_25G_LANE_RX_BIST_STATUS_STATE_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_STATUS_PATTERN_DET_MASK			0x78
#define SERDES_25G_LANE_RX_BIST_STATUS_PATTERN_DET_SHIFT		3

#define SERDES_25G_LANE_RX_BIST_BER_STATUS0_BIT_ERROR_COUNT_7_0_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_BER_STATUS0_BIT_ERROR_COUNT_7_0_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_BER_STATUS1_BIT_ERROR_COUNT_15_8_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_BER_STATUS1_BIT_ERROR_COUNT_15_8_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_BER_STATUS2_BIT_ERROR_COUNT_23_16_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_BER_STATUS2_BIT_ERROR_COUNT_23_16_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_BER_STATUS4_CYCLE_COUNT_7_0_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_BER_STATUS4_CYCLE_COUNT_7_0_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_BER_STATUS5_CYCLE_COUNT_15_8_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_BER_STATUS5_CYCLE_COUNT_15_8_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_BER_STATUS6_CYCLE_COUNT_23_16_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_BER_STATUS6_CYCLE_COUNT_23_16_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL0_NUM_CYCLES_7_0_MASK		0xFF
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL0_NUM_CYCLES_7_0_SHIFT		0

#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL1_NUM_CYCLES_15_8_MASK		0xFF
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL1_NUM_CYCLES_15_8_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL2_MAX_ERRORS_7_0_MASK		0xFF
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL2_MAX_ERRORS_7_0_SHIFT		0

#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL3_MAX_ERRORS_15_8_MASK		0xFF
#define SERDES_25G_LANE_RX_BIST_LOCK_CTRL3_MAX_ERRORS_15_8_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL0_NUM_CYCLES_7_0_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL0_NUM_CYCLES_7_0_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL1_NUM_CYCLES_15_8_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL1_NUM_CYCLES_15_8_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL2_MIN_ERRORS_7_0_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL2_MIN_ERRORS_7_0_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL3_MIN_ERRORS_15_8_MASK	0xFF
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL3_MIN_ERRORS_15_8_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL4_STOP_ON_LOSS_LOCK_MASK	0x01
#define SERDES_25G_LANE_RX_BIST_LOSS_LOCK_CTRL4_STOP_ON_LOSS_LOCK_SHIFT	0

#define SERDES_25G_LANE_RX_BIST_SHIFT_AMOUNT_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_SHIFT_AMOUNT_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_7_0_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_7_0_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_15_8_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_15_8_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_23_16_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_23_16_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_31_24_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_31_24_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_39_32_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_39_32_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_47_40_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_47_40_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_55_48_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_55_48_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_63_56_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_63_56_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_71_64_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_71_64_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_79_72_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_79_72_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_87_80_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_87_80_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_95_88_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_95_88_SHIFT				0

#define SERDES_25G_LANE_RX_BIST_UDP_103_96_MASK				0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_103_96_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_111_104_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_111_104_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_119_112_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_119_112_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_127_120_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_127_120_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_135_128_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_135_128_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_143_136_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_143_136_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_151_144_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_151_144_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_159_152_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_159_152_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_167_160_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_167_160_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_175_168_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_175_168_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_183_176_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_183_176_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_191_184_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_191_184_SHIFT			0

#define SERDES_25G_LANE_RX_BIST_UDP_199_192_MASK			0xFF
#define SERDES_25G_LANE_RX_BIST_UDP_199_192_SHIFT			0

/*********************************** FEATURE **********************************/
#define SERDES_25G_LANE_FEATURE_BASE					0x700

#define SERDES_25G_LANE_FEATURE_RXTERM_CFG0_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x00)
#define SERDES_25G_LANE_FEATURE_LOS_CAL_CFG0_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x04)
#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x05)
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x06)
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x07)
#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x08)
#define SERDES_25G_LANE_FEATURE_TX_CAL_CFG0_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x09)
#define SERDES_25G_LANE_FEATURE_ADAPT_CFG_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x0C)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x10)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG0_ADDR    (SERDES_25G_LANE_FEATURE_BASE + 0x11)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG1_ADDR    (SERDES_25G_LANE_FEATURE_BASE + 0x12)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG2_ADDR    (SERDES_25G_LANE_FEATURE_BASE + 0x13)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_AGC_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x14)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_APG_MAP_CFG_ADDR  (SERDES_25G_LANE_FEATURE_BASE + 0x15)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x16)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x17)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x18)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG2_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x19)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x1A)
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x1B)
#define SERDES_25G_LANE_FEATURE_DFE_CFG_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x1F)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x20)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG0_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x21)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG1_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x22)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG2_ADDR     (SERDES_25G_LANE_FEATURE_BASE + 0x23)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x24)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x25)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x26)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x27)
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x28)
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG0_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x30)
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG1_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x31)
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG2_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x32)
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG3_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x33)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG0_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x40)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG1_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x41)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG2_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x42)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG3_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x43)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG4_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x44)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG5_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x45)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG6_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x46)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG7_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x47)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG8_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x48)
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG9_ADDR	     (SERDES_25G_LANE_FEATURE_BASE + 0x49)
#define SERDES_25G_LANE_FEATURE_TEST_CFG0_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x50)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG0_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x58)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG1_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x59)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG2_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x5A)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG3_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x5B)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG4_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x5C)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG5_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x5D)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG6_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x5E)
#define SERDES_25G_LANE_FEATURE_SPARE_CFG7_ADDR		     (SERDES_25G_LANE_FEATURE_BASE + 0x5F)
/*******************************************************************************
 * masks and shifts
 ******************************************************************************/
#define SERDES_25G_LANE_FEATURE_RXTERM_CFG0_AC_COUPLED_MASK                          0x01
#define SERDES_25G_LANE_FEATURE_RXTERM_CFG0_AC_COUPLED_SHIFT                         0

#define SERDES_25G_LANE_FEATURE_LOS_CAL_CFG0_LOS_COMP_EN_MASK                        0x01
#define SERDES_25G_LANE_FEATURE_LOS_CAL_CFG0_LOS_COMP_EN_SHIFT                       0

#define SERDES_25G_LANE_FEATURE_LOS_CAL_CFG0_AGC_COMP_EN_MASK                        0x02
#define SERDES_25G_LANE_FEATURE_LOS_CAL_CFG0_AGC_COMP_EN_SHIFT                       1

#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_GN_EN_MASK                       0x01
#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_GN_EN_SHIFT                      0

#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ1_EN_MASK                      0x02
#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ1_EN_SHIFT                     1

#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ2_EN_MASK                      0x04
#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ2_EN_SHIFT                     2

#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ3_EN_MASK                      0x08
#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ3_EN_SHIFT                     3

#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ4_EN_MASK                      0x10
#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ4_EN_SHIFT                     4

#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ5_EN_MASK                      0x20
#define SERDES_25G_LANE_FEATURE_LEQ_OFFSET_CAL_CFG0_EQ5_EN_SHIFT                     5

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_SUMMODD_EN_MASK                  0x01
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_SUMMODD_EN_SHIFT                 0

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_SUMMEVEN_EN_MASK                 0x02
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_SUMMEVEN_EN_SHIFT                1

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_VSCANODD_EN_MASK                 0x04
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_VSCANODD_EN_SHIFT                2

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_VSCANEVEN_EN_MASK                0x08
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG0_VSCANEVEN_EN_SHIFT               3

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICEREVEN1_EN_MASK          0x01
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICEREVEN1_EN_SHIFT         0

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICEREVEN0_EN_MASK          0x02
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICEREVEN0_EN_SHIFT         1

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICERODD1_EN_MASK           0x04
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICERODD1_EN_SHIFT          2

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICERODD0_EN_MASK           0x08
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_DATASLICERODD0_EN_SHIFT          3

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EDGESLICEREVEN_EN_MASK           0x10
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EDGESLICEREVEN_EN_SHIFT          4

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EDGESLICERODD_EN_MASK            0x20
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EDGESLICERODD_EN_SHIFT           5

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EYESLICEREVEN_EN_MASK            0x40
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EYESLICEREVEN_EN_SHIFT           6

#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EYESLICERODD_EN_MASK             0x80
#define SERDES_25G_LANE_FEATURE_DFE_OFFSET_CAL_CFG1_EYESLICERODD_EN_SHIFT            7

#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_VCO_FREQ_EN_MASK                        0x01
#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_VCO_FREQ_EN_SHIFT                       0

#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL1_EN_MASK                     0x02
#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL1_EN_SHIFT                    1

#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL2_EN_MASK                     0x04
#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL2_EN_SHIFT                    2

#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL3_EN_MASK                     0x08
#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL3_EN_SHIFT                    3

#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL_RESULT_SEL_MASK              0x30
#define SERDES_25G_LANE_FEATURE_CDR_CAL_CFG0_CDR_IQ_CAL_RESULT_SEL_SHIFT             4

#define SERDES_25G_LANE_FEATURE_TX_CAL_CFG0_TX_REG_EN_MASK                           0x01
#define SERDES_25G_LANE_FEATURE_TX_CAL_CFG0_TX_REG_EN_SHIFT                          0

#define SERDES_25G_LANE_FEATURE_TX_CAL_CFG0_TX_DCD_EN_MASK                           0x02
#define SERDES_25G_LANE_FEATURE_TX_CAL_CFG0_TX_DCD_EN_SHIFT                          1

#define SERDES_25G_LANE_FEATURE_TX_CAL_CFG0_TXDP_CLOCK_PHASE_EN_MASK                 0x04
#define SERDES_25G_LANE_FEATURE_TX_CAL_CFG0_TXDP_CLOCK_PHASE_EN_SHIFT                2

#define SERDES_25G_LANE_FEATURE_ADAPT_CFG_EYE_MON_MASK                               0x01
#define SERDES_25G_LANE_FEATURE_ADAPT_CFG_EYE_MON_SHIFT                              0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_INIT0_MASK               0x03
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_INIT0_SHIFT              0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_INIT1_MASK               0x0C
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_INIT1_SHIFT              2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_EIE0_MASK                0x30
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_EIE0_SHIFT               4

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_EIE1_MASK                0xC0
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CFG_REPEAT_COUNT_EIE1_SHIFT               6

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG0_INTERVAL_7_0_MASK               0xFF
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG0_INTERVAL_7_0_SHIFT              0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG1_INTERVAL_15_8_MASK              0xFF
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG1_INTERVAL_15_8_SHIFT             0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG2_INTERVAL_23_16_MASK             0xFF
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_CONT_CFG2_INTERVAL_23_16_SHIFT            0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_AGC_CFG_INIT0_EN_MASK                     0x01
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_AGC_CFG_INIT0_EN_SHIFT                    0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_AGC_CFG_EIE0_EN_MASK                      0x04
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_AGC_CFG_EIE0_EN_SHIFT                     2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_APG_MAP_CFG_INIT0_EN_MASK                 0x01
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_APG_MAP_CFG_INIT0_EN_SHIFT                0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_APG_MAP_CFG_EIE0_EN_MASK                  0x04
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_APG_MAP_CFG_EIE0_EN_SHIFT                 2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_INIT0_SEL_MASK                    0x03
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_INIT0_SEL_SHIFT                   0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_INIT1_SEL_MASK                    0x0C
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_INIT1_SEL_SHIFT                   2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_EIE0_SEL_MASK                     0x30
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_EIE0_SEL_SHIFT                    4

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_EIE1_SEL_MASK                     0xC0
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_LFG_CFG_EIE1_SEL_SHIFT                    6

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT0_EDGE_EN_MASK               0x01
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT0_EDGE_EN_SHIFT              0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT0_DATA_EN_MASK               0x02
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT0_DATA_EN_SHIFT              1

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT1_EDGE_EN_MASK               0x04
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT1_EDGE_EN_SHIFT              2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT1_DATA_EN_MASK               0x08
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_INIT1_DATA_EN_SHIFT              3

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE0_EDGE_EN_MASK                0x10
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE0_EDGE_EN_SHIFT               4

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE0_DATA_EN_MASK                0x20
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE0_DATA_EN_SHIFT               5

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE1_EDGE_EN_MASK                0x40
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE1_EDGE_EN_SHIFT               6

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE1_DATA_EN_MASK                0x80
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG0_EIE1_DATA_EN_SHIFT               7

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_INIT0_RESULT_SEL_MASK            0x03
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_INIT0_RESULT_SEL_SHIFT           0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_INIT1_RESULT_SEL_MASK            0x0C
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_INIT1_RESULT_SEL_SHIFT           2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_EIE0_RESULT_SEL_MASK             0x30
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_EIE0_RESULT_SEL_SHIFT            4

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_EIE1_RESULT_SEL_MASK             0xC0
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG1_EIE1_RESULT_SEL_SHIFT            6

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG2_CONT_EDGE_EN_MASK                0x01
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG2_CONT_EDGE_EN_SHIFT               0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG2_CONT_DATA_EN_MASK                0x02
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG2_CONT_DATA_EN_SHIFT               1

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG2_CONT_RESULT_SEL_MASK             0x0C
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_HFG_CFG2_CONT_RESULT_SEL_SHIFT            2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_INIT0_EN_MASK                     0x01
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_INIT0_EN_SHIFT                    0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_INIT1_EN_MASK                     0x02
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_INIT1_EN_SHIFT                    1

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_EIE0_EN_MASK                      0x04
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_EIE0_EN_SHIFT                     2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_EIE1_EN_MASK                      0x08
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_EIE1_EN_SHIFT                     3

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_CONT_EN_MASK                      0x10
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_MBS_CFG_CONT_EN_SHIFT                     4

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_AGCLOS_START_VAL_SEL_MASK        0x01
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_AGCLOS_START_VAL_SEL_SHIFT       0

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_PLE_ATT_START_VAL_SEL_MASK       0x02
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_PLE_ATT_START_VAL_SEL_SHIFT      1

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_GN_APG_START_VAL_SEL_MASK        0x04
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_GN_APG_START_VAL_SEL_SHIFT       2

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_LFG_START_VAL_SEL_MASK        0x08
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_LFG_START_VAL_SEL_SHIFT       3

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_GNEQ_CCL_LFG_START_VAL_SEL_MASK  0x10
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_GNEQ_CCL_LFG_START_VAL_SEL_SHIFT 4

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_HFG_SQL_START_VAL_SEL_MASK    0x20
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_HFG_SQL_START_VAL_SEL_SHIFT   5

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_MBF_START_VAL_SEL_MASK        0x40
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_MBF_START_VAL_SEL_SHIFT       6

#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_MBG_START_VAL_SEL_MASK        0x80
#define SERDES_25G_LANE_FEATURE_CTLE_ADAPT_EIE0_CFG_EQ_MBG_START_VAL_SEL_SHIFT       7

#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP1_EN_MASK                                 0x01
#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP1_EN_SHIFT                                0

#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP2_EN_MASK                                 0x02
#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP2_EN_SHIFT                                1

#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP3_EN_MASK                                 0x04
#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP3_EN_SHIFT                                2

#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP4_EN_MASK                                 0x08
#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP4_EN_SHIFT                                3

#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP5_EN_MASK                                 0x10
#define SERDES_25G_LANE_FEATURE_DFE_CFG_TAP5_EN_SHIFT                                4

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CFG_METHOD_SEL_MASK                        0x01
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CFG_METHOD_SEL_SHIFT                       0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG0_INTERVAL_7_0_MASK                0xFF
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG0_INTERVAL_7_0_SHIFT               0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG1_INTERVAL_15_8_MASK               0xFF
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG1_INTERVAL_15_8_SHIFT              0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG2_INTERVAL_23_16_MASK              0xFF
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_CONT_CFG2_INTERVAL_23_16_SHIFT             0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_INIT_EN_MASK                 0x01
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_INIT_EN_SHIFT                0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_EIE_EN_MASK                  0x02
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_EIE_EN_SHIFT                 1

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_CONT_EN_MASK                 0x04
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_CONT_EN_SHIFT                2

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_START_VAL_SEL_MASK           0x08
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP1_CFG_TAP1_START_VAL_SEL_SHIFT          3

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_INIT_EN_MASK                 0x01
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_INIT_EN_SHIFT                0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_EIE_EN_MASK                  0x02
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_EIE_EN_SHIFT                 1

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_CONT_EN_MASK                 0x04
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_CONT_EN_SHIFT                2

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_START_VAL_SEL_MASK           0x08
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP2_CFG_TAP2_START_VAL_SEL_SHIFT          3

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_INIT_EN_MASK                 0x01
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_INIT_EN_SHIFT                0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_EIE_EN_MASK                  0x02
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_EIE_EN_SHIFT                 1

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_CONT_EN_MASK                 0x04
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_CONT_EN_SHIFT                2

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_START_VAL_SEL_MASK           0x08
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP3_CFG_TAP3_START_VAL_SEL_SHIFT          3

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_INIT_EN_MASK                 0x01
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_INIT_EN_SHIFT                0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_EIE_EN_MASK                  0x02
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_EIE_EN_SHIFT                 1

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_CONT_EN_MASK                 0x04
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_CONT_EN_SHIFT                2

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_START_VAL_SEL_MASK           0x08
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP4_CFG_TAP4_START_VAL_SEL_SHIFT          3

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_INIT_EN_MASK                 0x01
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_INIT_EN_SHIFT                0

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_EIE_EN_MASK                  0x02
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_EIE_EN_SHIFT                 1

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_CONT_EN_MASK                 0x04
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_CONT_EN_SHIFT                2

#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_START_VAL_SEL_MASK           0x08
#define SERDES_25G_LANE_FEATURE_DFE_ADAPT_TAP5_CFG_TAP5_START_VAL_SEL_SHIFT          3

#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG0_CDR_LOCKD_EN_MASK                       0x01
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG0_CDR_LOCKD_EN_SHIFT                      0

#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG0_CDR_LOCKD_TIMEOUT_US_MASK               0xFE
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG0_CDR_LOCKD_TIMEOUT_US_SHIFT              1

#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG1_CDR_LOCK_WAIT_TIME_US_MASK              0xFF
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG1_CDR_LOCK_WAIT_TIME_US_SHIFT             0

#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG2_CDR_FREQ_MEASURE_EN_MASK                0x01
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG2_CDR_FREQ_MEASURE_EN_SHIFT               0

#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG3_RXCLKDIV_EN_MASK                        0x01
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG3_RXCLKDIV_EN_SHIFT                       0

#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG3_BIST_HANDSHAKE_EN_MASK                  0x02
#define SERDES_25G_LANE_FEATURE_RX_CTRL_CFG3_BIST_HANDSHAKE_EN_SHIFT                 1

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG0_SIG_DET_MODE_MASK                       0x03
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG0_SIG_DET_MODE_SHIFT                      0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG0_LOS_DET_MODE_MASK                       0x0C
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG0_LOS_DET_MODE_SHIFT                      2

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG1_SIG_DET_THRESHOLD_MASK                  0xFF
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG1_SIG_DET_THRESHOLD_SHIFT                 0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG2_LOS_DET_THRESHOLD_MASK                  0xFF
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG2_LOS_DET_THRESHOLD_SHIFT                 0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG3_INTERVAL_7_0_MASK                       0xFF
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG3_INTERVAL_7_0_SHIFT                      0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG4_INTERVAL_15_8_MASK                      0xFF
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG4_INTERVAL_15_8_SHIFT                     0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG5_SAMPLE_LEN_7_0_MASK                     0xFF
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG5_SAMPLE_LEN_7_0_SHIFT                    0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG6_SAMPLE_LEN_11_8_MASK                    0x0F
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG6_SAMPLE_LEN_11_8_SHIFT                   0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG7_PLE_ATT_MASK                            0x07
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG7_PLE_ATT_SHIFT                           0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG7_EQ_LFG_MASK                             0xF8
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG7_EQ_LFG_SHIFT                            3

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG8_GN_APG_MASK                             0x03
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG8_GN_APG_SHIFT                            0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG8_HFG_SQL_MASK                            0x7C
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG8_HFG_SQL_SHIFT                           2

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG9_MBF_MASK                                0x0F
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG9_MBF_SHIFT                               0

#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG9_MBG_MASK                                0xF0
#define SERDES_25G_LANE_FEATURE_EYE_LOS_CFG9_MBG_SHIFT                               4

#define SERDES_25G_LANE_FEATURE_TEST_CFG0_LANE_MSM_DIS_MASK                          0x01
#define SERDES_25G_LANE_FEATURE_TEST_CFG0_LANE_MSM_DIS_SHIFT                         0

#define SERDES_25G_LANE_FEATURE_TEST_CFG0_RX_CTRL_DIS_MASK                           0x02
#define SERDES_25G_LANE_FEATURE_TEST_CFG0_RX_CTRL_DIS_SHIFT                          1

#define SERDES_25G_LANE_FEATURE_SPARE_CFG0_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG0_SHIFT                                     0

#define SERDES_25G_LANE_FEATURE_SPARE_CFG1_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG1_SHIFT                                     0

#define SERDES_25G_LANE_FEATURE_SPARE_CFG2_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG2_SHIFT                                     0

#define SERDES_25G_LANE_FEATURE_SPARE_CFG3_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG3_SHIFT                                     0

#define SERDES_25G_LANE_FEATURE_SPARE_CFG4_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG4_SHIFT                                     0

#define SERDES_25G_LANE_FEATURE_SPARE_CFG5_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG5_SHIFT                                     0

#define SERDES_25G_LANE_FEATURE_SPARE_CFG6_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG6_SHIFT                                     0

#define SERDES_25G_LANE_FEATURE_SPARE_CFG7_MASK                                      0xFF
#define SERDES_25G_LANE_FEATURE_SPARE_CFG7_SHIFT                                     0

#ifdef _cplusplus
}
#endif

#endif
